/*
 * Decompiled with CFR 0.152.
 */
package com.vuplex.webview;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.DownloadManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.net.Uri;
import android.net.http.SslError;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.os.Message;
import android.os.Parcelable;
import android.os.SystemClock;
import android.print.PrintAttributes;
import android.print.PrintDocumentAdapter;
import android.print.VuplexPdfPrinter;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.webkit.ClientCertRequest;
import android.webkit.ConsoleMessage;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.DownloadListener;
import android.webkit.GeolocationPermissions;
import android.webkit.HttpAuthHandler;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.SslErrorHandler;
import android.webkit.URLUtil;
import android.webkit.ValueCallback;
import android.webkit.WebBackForwardList;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.webkit.WebViewDatabase;
import android.widget.FrameLayout;
import com.unity3d.player.UnityPlayer;
import com.vuplex.webview.BiConsumer;
import com.vuplex.webview.ByteArrayResult;
import com.vuplex.webview.Consumer;
import com.vuplex.webview.FileSelectionRequest;
import com.vuplex.webview.HelperActivity;
import com.vuplex.webview.a;
import com.vuplex.webview.c;
import com.vuplex.webview.d;
import com.vuplex.webview.e;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WebView
implements DownloadListener,
WebView.FindListener,
com.vuplex.webview.f {
    public static final String TAG = "3D WebView";
    private static boolean Q;
    private static boolean R;
    private static boolean S;
    private static String T;
    private static String U;
    private static boolean V;
    private static boolean W;
    private static String X;
    private static boolean Y;
    private static boolean Z;
    private static boolean a0;
    private static boolean b0;
    private static boolean c0;
    private static ViewGroup d0;
    protected static l e0;
    private static Method f0;
    private static final HashMap<String, c> g0;
    private static boolean h0;
    private static ArrayList<WebView> i0;
    private BiConsumer<String, Object> a;
    private String b;
    private String c = "none";
    private int d = 1;
    private Consumer<ClientCertRequest> e;
    private boolean f;
    private boolean g;
    private boolean h = true;
    protected boolean i;
    private a j;
    private BroadcastReceiver k;
    private Consumer<FileSelectionRequest> l;
    private String m;
    private boolean n;
    private boolean o = true;
    protected View p;
    private String q;
    protected int r;
    private boolean s;
    private j t;
    private ValueCallback<Uri[]> u;
    private boolean v = true;
    private boolean w = true;
    private boolean x = true;
    private boolean y = true;
    private NumberFormat z = NumberFormat.getInstance(Locale.ROOT);
    private boolean A;
    private HashMap<String, JSONObject> B;
    private boolean C;
    private BiConsumer<String, Object> D;
    private k E;
    private Message F;
    private float G;
    private boolean H;
    private BiConsumer<String, Consumer<Boolean>> I;
    private BiConsumer<String, Consumer<Boolean>> J;
    private long K;
    private String L;
    protected android.webkit.WebView M;
    private e N;
    protected int O;
    protected boolean P;

    public void bringToFront() {
        WebView.a(() -> this.M.bringToFront());
    }

    public void canGoBack(Consumer<Boolean> callback) {
        WebView.a(() -> callback.accept(this.M.canGoBack()));
    }

    public void canGoForward(Consumer<Boolean> callback) {
        WebView.a(() -> callback.accept(this.M.canGoForward()));
    }

    public void captureScreenshot(Consumer<ByteArrayResult> callback) {
        WebView.a(() -> {
            ByteArrayResult byteArrayResult;
            Bitmap bitmap = this.d();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
            ByteArrayResult byteArrayResult2 = byteArrayResult;
            byteArrayResult = new ByteArrayResult(stream.toByteArray());
            callback.accept(byteArrayResult2);
        });
    }

    public void clearFindMatches() {
        this.m = null;
        WebView.a(() -> this.M.clearMatches());
    }

    public void clearHistory() {
        WebView.a(() -> this.M.clearHistory());
    }

    public void click(int unscaledX, int unscaledY, boolean preventStealingFocus) {
        this.movePointer(unscaledX, unscaledY, false);
        this.pointerDown(unscaledX, unscaledY, 0, 1, preventStealingFocus);
        this.pointerUp(unscaledX, unscaledY, 0, 1);
        this.movePointer(unscaledX, unscaledY, true);
    }

    public void createPdf(final Consumer<String> callback) {
        File directory = new File(WebView.f().getCacheDir().getAbsolutePath(), "/Vuplex.WebView/pdfs");
        String fileName = UUID.randomUUID().toString() + ".pdf";
        PrintAttributes.MediaSize mediaSize = PrintAttributes.MediaSize.ISO_A4;
        PrintAttributes.Builder builder = new PrintAttributes.Builder().setMediaSize(mediaSize).setResolution(new PrintAttributes.Resolution("pdf", "pdf", 600, 600));
        mediaSize = PrintAttributes.Margins.NO_MARGINS;
        PrintAttributes printAttributes = builder.setMinMargins((PrintAttributes.Margins)mediaSize).build();
        VuplexPdfPrinter pdfPrinter = new VuplexPdfPrinter(printAttributes);
        WebView.a(() -> {
            VuplexPdfPrinter.b b2;
            PrintDocumentAdapter printAdapter = this.M.createPrintDocumentAdapter("PDF Creation");
            VuplexPdfPrinter.b b3 = b2;
            b2 = new VuplexPdfPrinter.b(this){

                @Override
                public void a(String filePath) {
                    callback.accept(filePath);
                }

                @Override
                public void a() {
                    callback.accept("");
                }
            };
            pdfPrinter.print(printAdapter, directory, fileName, b3);
        });
    }

    public void destroy() {
        WebView.a(() -> {
            i0.remove(this);
            this.j();
            this.M.destroy();
        });
        a a2 = this.j;
        if (a2 != null) {
            a2.c();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void executeJavaScript(String javaScript, final Consumer<String> callback) {
        void valueCallback;
        ValueCallback<String> valueCallback2;
        if (callback == null) {
            valueCallback2 = null;
        } else {
            ValueCallback<String> valueCallback3;
            valueCallback2 = valueCallback3;
            valueCallback3 = new ValueCallback<String>(this){

                public void a(String result) {
                    if (result.charAt(0) == '\"' && result.charAt(result.length() - 1) == '\"') {
                        int n2 = result.length() - 1;
                        String string = result.substring(1, n2).replace("\\\"", "\"");
                        result = string.replace("\\\\", "\\");
                    }
                    callback.accept(result);
                }
            };
        }
        WebView.a(() -> this.a(javaScript, (ValueCallback)valueCallback));
    }

    public void find(String text, boolean forward) {
        String string = this.m;
        if (string != null && string.equals(text)) {
            WebView.a(() -> this.M.findNext(forward));
        } else {
            this.m = text;
            WebView.a(() -> this.M.findAllAsync(text));
        }
    }

    public void flingScroll(float velocityX, float velocityY) {
        WebView.a(() -> this.M.flingScroll((int)(velocityX * 30.0f), (int)(velocityY * 30.0f)));
    }

    public android.webkit.WebView getNativeWebView() {
        return this.M;
    }

    public void getRawTextureData(Consumer<ByteArrayResult> callback) {
        WebView.a(() -> {
            ByteArrayResult byteArrayResult;
            Bitmap bitmap = this.d();
            Matrix matrix = new Matrix();
            float f2 = bitmap.getWidth() / 2;
            float f3 = bitmap.getHeight() / 2;
            matrix.postScale(1.0f, -1.0f, f2, f3);
            int n2 = bitmap.getWidth();
            int n3 = bitmap.getHeight();
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n2, (int)n3, (Matrix)matrix, (boolean)false);
            int bufferSize = bitmap.getWidth() * bitmap.getHeight() * 4;
            ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
            bitmap.copyPixelsToBuffer((Buffer)buffer);
            ByteArrayResult byteArrayResult2 = byteArrayResult;
            byteArrayResult = new ByteArrayResult(buffer.array());
            callback.accept(byteArrayResult2);
        });
    }

    public void goBack() {
        WebView.a(() -> this.M.goBack());
    }

    public void goForward() {
        WebView.a(() -> this.M.goForward());
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleBridgeMessage(String serializedMessage) {
        block11: {
            String string;
            boolean bl;
            void downloadId;
            boolean bl2 = serializedMessage.contains("vuplex.webview.pageTransparencyDetermined");
            if (bl2) {
                void pageIsTransparent;
                JSONObject jSONObject;
                bl2 = this.h;
                if (!bl2) return;
                JSONObject jSONObject2 = jSONObject;
                jSONObject2(serializedMessage);
                JSONObject json22 = jSONObject2;
                boolean bl3 = json22.getBoolean("value");
                this.b((boolean)pageIsTransparent);
                return;
            }
            boolean json22 = serializedMessage.contains("vuplex.webview.blobUrlDownloadFinished");
            if (!json22) break block11;
            JSONObject jSONObject = json22;
            jSONObject(serializedMessage);
            JSONObject json22 = jSONObject;
            String pageIsTransparent = json22.getString("downloadId");
            JSONObject jSONObject3 = this.B;
            JSONObject downloadMessage = jSONObject3 = jSONObject3.get(downloadId);
            HashMap<String, JSONObject> hashMap = this.B;
            hashMap.remove(downloadId);
            boolean failed = bl = json22.getBoolean("failed");
            if (!failed) {
                FileOutputStream fileOutputStream;
                byte[] byArray;
                String string2;
                String base64Data = string2 = json22.getString("base64Data");
                String filePath = string = downloadMessage.getString("FilePath");
                byte[] bytes = byArray = Base64.decode((String)base64Data, (int)0);
                FileOutputStream fileOutputStream2 = fileOutputStream;
                fileOutputStream2(filePath, false);
                FileOutputStream outputStream = fileOutputStream2;
                outputStream.write(bytes);
                outputStream.flush();
            }
            int base64Data = failed ? 2 : 1;
            int progressChangeType2222222 = base64Data;
            downloadMessage.put("Progress", 1);
            {
                catch (JSONException progressChangeType2222222) {
                    JSONException ex = progressChangeType2222222;
                    String string3 = string = TAG;
                    string = "An unexpected exception occurred while forming a download message.";
                    Log.e((String)string3, (String)string, (Throwable)ex);
                    return;
                }
            }
            downloadMessage.put("Type", progressChangeType2222222);
            this.a(downloadMessage);
            return;
        }
        try {
            this.a(serializedMessage);
            return;
        }
        catch (Exception json) {
            void e2;
            e2 = e2;
            Log.e((String)TAG, (String)"Exception occurred", (Throwable)e2);
        }
    }

    public void loadHtml(String html) {
        this.loadHtml(html, null);
    }

    /*
     * WARNING - void declaration
     */
    public void loadHtml(String html, String baseUrl) {
        void encodedHtml;
        String string = baseUrl == null ? html.replace("%", "%25").replace("#", "%23").replace("\n", "%0A") : html;
        WebView.a(() -> this.a(baseUrl, (String)encodedHtml, html));
    }

    public void loadUrl(String url) {
        this.loadUrl(url, null);
    }

    public void loadUrl(String url, Map<String, String> additionalHttpHeaders) {
        String urlToLoad = this.i(url);
        if (this.g(urlToLoad)) {
            this.loadHtml(com.vuplex.webview.d.a(urlToLoad), urlToLoad);
            return;
        }
        WebView.a(() -> {
            if (additionalHttpHeaders == null) {
                if (WebView.e().startsWith("91.") && !urlToLoad.startsWith("file:")) {
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = urlToLoad;
                    this.c(String.format("window.location = '%s';", objectArray2));
                } else {
                    this.M.loadUrl(urlToLoad);
                }
            } else {
                this.M.loadUrl(urlToLoad, additionalHttpHeaders);
            }
        });
    }

    public void movePointer(int unscaledX, int unscaledY, boolean pointerLeave) {
        if (pointerLeave) {
            unscaledX = 0;
            unscaledY = 0;
        }
        if (this.b() && !R) {
            int x = this.c(unscaledX);
            int y = this.c(unscaledY);
            String string = this.c;
            this.j.a(x, y, "mouseMoved", string, 0);
            return;
        }
        int x = this.C ? 2 : 7;
        int eventType = x;
        int n2 = this.d;
        this.a(eventType, unscaledX, unscaledY, n2);
    }

    public void onFindResultReceived(int activeMatchOrdinal, int numberOfMatches, boolean isDoneCounting) {
        if (isDoneCounting) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = numberOfMatches;
            objectArray[1] = activeMatchOrdinal;
            String results = String.format("%d,%d", objectArray2);
            this.d("HandleFindResult", results);
        }
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long contentLength) {
        Object downloadManager22;
        String filePath;
        Object file;
        String downloadId;
        String fileName = URLUtil.guessFileName((String)url, (String)contentDisposition, (String)mimeType);
        if (url.startsWith("blob:")) {
            downloadId = UUID.randomUUID().toString();
            File blobDownloadsDirPath = new File(WebView.f().getCacheDir().getAbsolutePath() + "/Vuplex.WebView/downloads");
            if (!blobDownloadsDirPath.exists()) {
                blobDownloadsDirPath.mkdirs();
            }
            if (((File)(file = new File(blobDownloadsDirPath, fileName))).exists()) {
                ((File)file).delete();
            }
            filePath = ((File)file).getAbsolutePath();
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray[0] = url;
            objectArray[1] = mimeType;
            objectArray[2] = downloadId;
            this.c(String.format("_vuplexInternal.downloadBlobUrl('%s', '%s', '%s');", objectArray2));
        } else {
            Object request = new DownloadManager.Request(Uri.parse((String)url));
            request.setMimeType(mimeType);
            String cookies = CookieManager.getInstance().getCookie(url);
            request.addRequestHeader("Cookie", cookies);
            request.addRequestHeader("User-Agent", userAgent);
            request.setDescription((CharSequence)"Downloading file...");
            request.setTitle((CharSequence)fileName);
            request.allowScanningByMediaScanner();
            request.setNotificationVisibility(0);
            file = Environment.DIRECTORY_DOWNLOADS;
            request.setDestinationInExternalFilesDir(WebView.f(), (String)file, fileName);
            downloadManager22 = (DownloadManager)WebView.f().getSystemService("download");
            String downloadId2 = String.valueOf(downloadManager22.enqueue(request));
            String filePath2 = WebView.f().getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS) + "/" + fileName;
            request = downloadId2;
            filePath = filePath2;
        }
        JSONObject downloadMessage = new JSONObject();
        downloadMessage.put("ContentType", (Object)mimeType);
        downloadMessage.put("FilePath", (Object)filePath);
        downloadMessage.put("Id", (Object)downloadId);
        downloadMessage.put("Progress", 0);
        downloadMessage.put("Type", 0);
        downloadMessage.put("Url", (Object)url);
        downloadManager22 = this.B;
        ((HashMap)downloadManager22).put(downloadId, downloadMessage);
        try {
            this.a(downloadMessage);
        }
        catch (JSONException downloadManager22) {
            JSONException ex = downloadManager22;
            Log.e((String)TAG, (String)"An unexpected exception occurred while forming a download message.", (Throwable)ex);
        }
    }

    public void pause() {
        WebView.a(() -> this.M.onPause());
    }

    public void pointerDown(int unscaledX, int unscaledY, int mouseButton, int clickCount, boolean preventStealingFocus) {
        int n2;
        this.C = true;
        if (!preventStealingFocus) {
            WebView.a(() -> this.M.requestFocus());
        }
        if (this.b() && !R) {
            String buttonName;
            int x = this.c(unscaledX);
            int y = this.c(unscaledY);
            this.c = buttonName = this.a(mouseButton);
            this.j.a(x, y, "mouseMoved", buttonName, 0);
            this.j.a(x, y, "mousePressed", buttonName, clickCount);
            return;
        }
        this.d = n2 = this.b(mouseButton);
        this.a(0, unscaledX, unscaledY, n2);
        n2 = this.d;
        this.a(11, unscaledX, unscaledY, n2);
    }

    public void pointerUp(int unscaledX, int unscaledY, int mouseButton, int clickCount) {
        this.C = false;
        if (this.b() && !R) {
            int x = this.c(unscaledX);
            int y = this.c(unscaledY);
            String buttonName = this.a(mouseButton);
            this.j.a(x, y, "mouseReleased", buttonName, clickCount);
            this.c = "none";
            return;
        }
        int n2 = this.d;
        this.a(12, unscaledX, unscaledY, n2);
        this.a(1, unscaledX, unscaledY, 0);
    }

    public void postUrl(String url, byte[] data) {
        WebView.a(() -> this.M.postUrl(url, data));
    }

    public void reload() {
        WebView.a(() -> this.M.reload());
    }

    public void resize(int width, int height) {
        WebView.a(() -> this.a(width, height));
    }

    public void resume() {
        WebView.a(() -> {
            this.M.onResume();
            ValueCallback<Uri[]> valueCallback = this.u;
            if (valueCallback != null) {
                valueCallback.onReceiveValue(null);
                this.u = null;
            }
        });
    }

    public void scroll(int unscaledDeltaX, int unscaledDeltaY) {
        int scaledDeltaX = this.c(unscaledDeltaX);
        int scaledDeltaY = this.c(unscaledDeltaY);
        this.M.scrollBy(scaledDeltaX, scaledDeltaY);
    }

    public void scroll(int unscaledDeltaX, int unscaledDeltaY, int unscaledPointerX, int unscaledPointerY) {
        this.a(8, unscaledPointerX, unscaledPointerY, 0, unscaledDeltaX, unscaledDeltaY);
    }

    /*
     * WARNING - void declaration
     */
    public void sendKey(String key) {
        if (this.b() && !Q) {
            void isSurrogatePair;
            HashMap<String, c> hashMap = g0;
            if (hashMap.containsKey(key)) {
                c keyDescription = hashMap.get(key);
                Object object = this.j;
                a a2 = object;
                object = keyDescription.a();
                int n2 = keyDescription.b();
                String string = keyDescription.c();
                a2.a(0, keyDescription.d(), (String)object, n2, string);
                return;
            }
            boolean keyDescription = key.length() == 2 && Character.isSurrogatePair(key.charAt(0), key.charAt(1));
            if (isSurrogatePair != false) {
                this.j.b(key);
            } else {
                this.j.a(key);
            }
            return;
        }
        if (!key.equals("Enter") && !key.equals("\n")) {
            if (key.equals("Backspace")) {
                key = "\b";
            } else if (key.equals("\\")) {
                key = "\\\\";
            } else if (key.equals("'")) {
                key = "\\'";
            }
        } else {
            key = "\\n";
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = key;
        this.c(String.format("_vuplexInternal.keyboardInputManager.sendKey('%s');", objectArray2));
    }

    public void setAuthRequestedHandler(BiConsumer<String, Object> callback) {
        this.a = callback;
    }

    public void setClientCertificateRequestedHandler(Consumer<ClientCertRequest> callback) {
        this.e = callback;
    }

    public void setConsoleMessageEventsEnabled(boolean enabled) {
        this.f = enabled;
    }

    public void setDeepLinkingEnabled(boolean enabled) {
        this.g = enabled;
    }

    public void setDefaultBackgroundEnabled(boolean enabled) {
        this.h = enabled;
        this.b(enabled ^ true);
        this.q();
    }

    /*
     * WARNING - void declaration
     */
    public void setDownloadsEnabled(boolean enabled) {
        void alreadyEnabled;
        boolean bl = this.k != null;
        if (enabled == alreadyEnabled) {
            return;
        }
        if (enabled) {
            BroadcastReceiver broadcastReceiver;
            BroadcastReceiver broadcastReceiver2 = broadcastReceiver;
            broadcastReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    String downloadId = String.valueOf(intent.getLongExtra("extra_download_id", -1L));
                    JSONObject downloadMessage = (JSONObject)WebView.this.B.get(downloadId);
                    if (downloadMessage == null) {
                        return;
                    }
                    WebView.this.B.remove(downloadId);
                    downloadMessage.put("Type", 1);
                    downloadMessage.put("Progress", 1);
                    WebView webView = WebView.this;
                    try {
                        webView.a(downloadMessage);
                    }
                    catch (JSONException jSONException) {
                        JSONException ex = jSONException;
                        Log.e((String)WebView.TAG, (String)"An unexpected exception occurred while forming a download message.", (Throwable)ex);
                    }
                }
            };
            this.k = broadcastReceiver2;
            if (Build.VERSION.SDK_INT >= 34) {
                WebView.f().registerReceiver(this.k, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"), 2);
            } else {
                WebView.f().registerReceiver(this.k, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"));
            }
        } else {
            WebView.f().unregisterReceiver(this.k);
            this.k = null;
        }
        WebView.a(() -> {
            android.webkit.WebView webView = this.M;
            WebView webView2 = enabled ? this : null;
            webView.setDownloadListener((DownloadListener)webView2);
        });
    }

    public void setFileSelectionHandler(Consumer<FileSelectionRequest> callback) {
        this.l = callback;
    }

    public void setFocused(boolean focused) {
        WebView.a(() -> {
            if (focused) {
                this.M.requestFocus();
                this.M.evaluateJavascript("_vuplexInternal.focusManager.setFocused(true);", null);
            } else {
                this.M.clearFocus();
                this.M.evaluateJavascript("_vuplexInternal.focusManager.setFocused(false);", null);
            }
        });
    }

    public void setFocusedInputFieldEventsEnabled(boolean enabled) {
        this.n = enabled;
        this.q();
    }

    public void setForceDark(int forceDark) {
        if (Build.VERSION.SDK_INT >= 29) {
            WebView.a(() -> this.M.getSettings().setForceDark(forceDark));
        } else {
            Log.w((String)TAG, (String)"AndroidWebView.SetForceDark() was called but will be ignored because that API is only available on Android API level >= 29.");
        }
    }

    public void setFullscreenEnabled(boolean enabled) {
        if (this.o == enabled) {
            return;
        }
        this.o = enabled;
        WebView.a(() -> this.l());
    }

    public void setInitialScale(float scale) {
        this.a(scale, false);
    }

    public void setMediaPlaybackRequiresUserGesture(boolean setMediaPlaybackRequiresUserGesture) {
        WebView.a(() -> this.M.getSettings().setMediaPlaybackRequiresUserGesture(setMediaPlaybackRequiresUserGesture));
    }

    public void setMixedContentMode(int mode) {
        WebView.a(() -> this.M.getSettings().setMixedContentMode(mode));
    }

    public void setNativeFileSelectionEnabled(boolean enabled) {
        this.v = enabled;
    }

    public void setNativeJavaScriptDialogsEnabled(boolean enabled) {
        this.w = enabled;
    }

    public void setNativeOnScreenKeyboardEnabled(boolean enabled) {
        this.x = enabled;
        WebView.a(() -> {
            this.M.setFocusable(enabled);
            this.M.setFocusableInTouchMode(enabled);
        });
    }

    public void setNativeZoomEnabled(boolean enabled) {
        this.y = enabled;
        this.q();
        if (!enabled) {
            this.c("_vuplexInternal.viewportMetaTagManager.overrideViewportMetaTag()");
        }
    }

    public void setPopupMode(int popupMode) {
        this.E = com.vuplex.webview.WebView$k.values()[popupMode];
        WebView.a(() -> {
            void supportMultipleWindows;
            k k2 = this.E;
            boolean bl = k2 == com.vuplex.webview.WebView$k.b || k2 == com.vuplex.webview.WebView$k.c;
            this.M.getSettings().setSupportMultipleWindows((boolean)supportMultipleWindows);
        });
    }

    public void setRect(int x, int y, int width, int height) {
        WebView.a(() -> {
            this.M.setX((float)x);
            this.M.setY((float)y);
            this.a(width, height);
        });
    }

    public void setRenderingEnabled(boolean enabled) {
    }

    public void setScriptAlertHandler(BiConsumer<String, Consumer<Boolean>> callback) {
        this.I = callback;
    }

    public void setScriptConfirmHandler(BiConsumer<String, Consumer<Boolean>> callback) {
        this.J = callback;
    }

    public void setScrollbarsEnabled(boolean enabled) {
        this.M.setVerticalScrollBarEnabled(enabled);
        this.M.setHorizontalScrollBarEnabled(enabled);
    }

    public void setTextZoom(int textZoom) {
        WebView.a(() -> this.M.getSettings().setTextZoom(textZoom));
    }

    public void setUserAgent(boolean mobile) {
        WebView.a(() -> {
            void userAgent;
            String string = mobile ? null : WebView.g();
            this.M.getSettings().setUserAgentString((String)userAgent);
        });
    }

    public void setUserAgent(String userAgent) {
        WebView.a(() -> this.M.getSettings().setUserAgentString(userAgent));
    }

    public void setVisible(boolean visible) {
        WebView.a(() -> {
            if (visible) {
                this.M.bringToFront();
            } else {
                this.j();
                this.a(false);
            }
        });
    }

    public void stopLoad() {
        WebView.a(() -> this.M.stopLoading());
    }

    public void zoomBy(float zoomFactor) {
        WebView.a(() -> this.M.zoomBy(zoomFactor));
    }

    public void zoomIn() {
        WebView.a(() -> this.a(this.G + 0.1f, true));
    }

    public void zoomOut() {
        WebView.a(() -> this.a(Math.max(this.G - 0.1f, 0.1f), true));
    }

    protected android.webkit.WebView a() {
        h webView = new h(this, WebView.f());
        webView.getSettings().setBuiltInZoomControls(true);
        webView.getSettings().setDisplayZoomControls(false);
        return webView;
    }

    protected void a(Canvas canvas) {
        ((h)this.M).a(canvas);
    }

    void i() {
        final String connectionUrl = "about:blank#" + UUID.randomUUID().toString();
        this.M.loadUrl(connectionUrl);
        AsyncTask<Void, Void, Void> initDevToolsTask = new AsyncTask<Void, Void, Void>(){

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private void a(com.vuplex.webview.g devTools, int attemptsRemaining) {
                if (devTools != null) ** GOTO lbl8
                try {
                    v0 = var3_3;
                    v0();
                    unconnectedDevTools = v0;
                    unconnectedDevTools.b();
                    devTools = unconnectedDevTools;
lbl8:
                    // 2 sources

                    unconnectedDevTools = devTools.c();
                    var4_5 = pages.iterator();
                    while (var5_7 = var4_5.hasNext()) {
                        var5_6 = var4_5.next();
                        var6_9 = connectionUrl;
                        page = var5_6 = (a)var5_6;
                        var6_9 = page.e();
                        var6_8 = var6_9.equals(var6_9);
                        if (!var6_8 || (var6_8 = page.f())) continue;
                        var4_5 = WebView.this;
                        WebView.a((WebView)var4_5, (a)page);
                    }
                }
                catch (Exception pages) {
                    e = e;
                    Log.e((String)"3D WebView", (String)"An exception occurred while polling for an unconnected page.", (Throwable)e);
                }
                if (WebView.h(WebView.this) == null) {
                    this.b((com.vuplex.webview.g)devTools, attemptsRemaining);
                    return;
                }
                WebView.h(WebView.this).a(new a.d(){

                    @Override
                    public void a(int executionContextId) {
                        WebView.this.j.a(executionContextId, WebView.this.b);
                    }
                });
                WebView.h(WebView.this).a(new a.c(){

                    @Override
                    public void a() {
                        WebView.this.j.d();
                    }
                });
                WebView.b(WebView.this, true);
                WebView.e(WebView.this, "HandleInitFinished");
                if (WebView.z(WebView.this) != null) {
                    url = WebView.z(WebView.this);
                    WebView.f(WebView.this, null);
                    WebView.this.loadUrl(url);
                }
            }

            private void b(final com.vuplex.webview.g devTools, final int attemptsRemaining) {
                TimerTask timerTask;
                if (attemptsRemaining <= 1) {
                    Log.e((String)WebView.TAG, (String)"Connecting to the page failed and no connection attempts are remaining.");
                    return;
                }
                TimerTask timerTask2 = timerTask;
                timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        Object[] objectArray = new Object[1];
                        Object[] objectArray2 = objectArray;
                        objectArray[0] = attemptsRemaining;
                        Log.d((String)WebView.TAG, (String)String.format("Couldn't connect to the page. Trying again with %s attempts remaining", objectArray2));
                        this.a(devTools, attemptsRemaining - 1);
                    }
                };
                new Timer().schedule(timerTask2, 100L);
            }

            /*
             * WARNING - void declaration
             */
            protected Void a(Void ... params) {
                try {
                    this.a(null, 100);
                }
                catch (Exception exception) {
                    void e2;
                    e2 = e2;
                    Log.e((String)WebView.TAG, (String)"An unexpected error occurred while connecting to a page", (Throwable)e2);
                }
                return null;
            }
        };
        initDevToolsTask.execute((Object[])new Void[0]);
    }

    /*
     * WARNING - void declaration
     */
    boolean g(String urlString) {
        boolean bl;
        block6: {
            block5: {
                void path;
                if (urlString == null) {
                    return false;
                }
                try {
                    URL uRL;
                    URL uRL2 = uRL;
                    uRL2(urlString);
                    URL url = uRL2;
                    String string = url.getPath();
                    if (path == null) break block5;
                }
                catch (MalformedURLException url) {
                    void e2;
                    e2 = e2;
                    return false;
                }
                bl = path.endsWith(".pdf");
                if (!bl) break block5;
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    protected void d(String methodName, String param) {
        UnityPlayer.UnitySendMessage((String)this.q, (String)methodName, (String)param);
    }

    protected boolean m() {
        boolean bl = e0 == com.vuplex.webview.WebView$l.b;
        return bl;
    }

    protected boolean n() {
        return false;
    }

    protected boolean o() {
        boolean bl = this.y;
        return bl ^= true;
    }

    protected boolean p() {
        return true;
    }

    public WebView(String gameObjectName, int x, int y, int width, int height, BiConsumer<String, Object> popupHandler, Message popupResultMessage) {
        HashMap hashMap;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        this.B = hashMap2;
        this.E = com.vuplex.webview.WebView$k.a;
        this.G = 1.0f;
        if (!WebView.e("6342b0fc-0034-4424-a882-13df9bd2c13e")) {
            this.q = gameObjectName;
            this.O = width;
            this.r = height;
            this.D = popupHandler;
            this.F = popupResultMessage;
            this.q();
            this.b(x, y, width, height);
            return;
        }
        throw new Exception("Your trial of 3D WebView for Android has expired. Please purchase a license to continue using it.");
    }

    public static void clearAllData() {
        WebView.a(() -> {
            Context context = WebView.f();
            WebViewDatabase.getInstance((Context)context).clearFormData();
            WebStorage.getInstance().deleteAllData();
            if (Build.VERSION.SDK_INT >= 22) {
                CookieManager.getInstance().removeAllCookies(null);
                CookieManager.getInstance().flush();
            } else {
                CookieSyncManager cookieSyncMngr = CookieSyncManager.createInstance((Context)context);
                cookieSyncMngr.startSync();
                CookieManager cookieManager = CookieManager.getInstance();
                cookieManager.removeAllCookie();
                cookieManager.removeSessionCookie();
                cookieSyncMngr.stopSync();
                cookieSyncMngr.sync();
            }
            if (i0.size() > 0) {
                i0.get(0).getNativeWebView().clearCache(true);
            } else {
                W = true;
            }
        });
    }

    public static void deleteCookies(String originalUrl, String targetCookieName) {
        List<String> originalUrlCookies = WebView.b(originalUrl, targetCookieName);
        Uri uri = Uri.parse((String)originalUrl);
        String[] parentDomains = WebView.a(uri);
        HashMap<String, List<String>> parentDomainsToCookies = new HashMap<String, List<String>>();
        int n2 = parentDomains.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String parentDomain = parentDomains[i2];
            String parentDomainUrl = uri.getScheme() + "://" + parentDomain;
            List<String> parentDomainCookies = WebView.b(parentDomainUrl, targetCookieName);
            parentDomainsToCookies.put(parentDomain, parentDomainCookies);
        }
        for (String cookie : originalUrlCookies) {
            String cookieDomain = null;
            for (String parentDomain : parentDomains) {
                boolean parentDomainContainsCookie = ((List)parentDomainsToCookies.get(parentDomain)).contains(cookie);
                if (!parentDomainContainsCookie) continue;
                cookieDomain = parentDomain;
                break;
            }
            String newCookie = cookie.split("=", 2)[0] + "=";
            if (cookieDomain != null) {
                newCookie = newCookie + "; domain=" + cookieDomain;
            }
            CookieManager.getInstance().setCookie(originalUrl, newCookie);
        }
    }

    public static void flushCookies() {
        WebView.a(() -> CookieManager.getInstance().flush());
    }

    public static String getCookies(String url, String cookieName) {
        List<String> nameValuePairs = WebView.b(url, cookieName);
        ArrayList<JSONObject> cookieJsonObjects = new ArrayList<JSONObject>();
        for (String nameValuePair : nameValuePairs) {
            String string;
            String string2;
            String[] nameAndValue = nameValuePair.split("=", 2);
            JSONObject cookie = new JSONObject();
            try {
                string2 = "Name";
                string = nameAndValue[0];
            }
            catch (JSONException jSONException) {
                JSONException ex = jSONException;
                Log.e((String)TAG, (String)("JSONException while creating the cookie object: " + (Object)((Object)ex)));
                continue;
            }
            cookie.put(string2, (Object)string);
            String string3 = "Value";
            string = nameAndValue[1];
            cookie.put(string3, (Object)string);
            cookieJsonObjects.add(cookie);
        }
        JSONObject jsonResponse = new JSONObject();
        String string = "Items";
        try {
            String nameValuePair;
            nameValuePair = new JSONArray(cookieJsonObjects);
            jsonResponse.put(string, (Object)nameValuePair);
        }
        catch (JSONException nameValuePair) {
            JSONException ex = nameValuePair;
            Log.e((String)TAG, (String)("JSONException while creating the cookie response: " + (Object)((Object)ex)));
        }
        return jsonResponse.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static void globallySetUserAgent(boolean mobile) {
        void userAgent;
        String string = mobile ? null : WebView.g();
        X = userAgent;
        WebView.a(() -> WebView.k((String)userAgent));
    }

    public static void globallySetUserAgent(String userAgent) {
        X = userAgent;
        WebView.a(() -> {
            for (WebView webView : i0) {
                webView.M.getSettings().setUserAgentString(userAgent);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isWebViewAvailable() {
        try {
            android.webkit.WebView.setWebContentsDebuggingEnabled((boolean)true);
            return true;
        }
        catch (Exception exception) {
            void e2;
            e2 = e2;
            return !e2.getMessage().contains("MissingWebViewPackageException");
        }
    }

    public static void pauseAll() {
        for (WebView webView : i0) {
            webView.pause();
        }
        WebView.a(() -> {
            if (i0.size() > 0) {
                WebView.i0.get((int)0).M.pauseTimers();
            }
        });
    }

    public static void resumeAll() {
        for (WebView webView : i0) {
            webView.resume();
        }
        WebView.a(() -> {
            if (i0.size() > 0) {
                WebView.i0.get((int)0).M.resumeTimers();
            }
        });
    }

    public static void setAlternativeKeyboardInputSystemEnabled(boolean enabled) {
        Q = enabled;
    }

    public static void setAlternativePointerInputSystemEnabled(boolean enabled) {
        R = enabled;
    }

    public static void setAutoplayEnabled(boolean enabled) {
        S = enabled;
        WebView.a(() -> {
            for (WebView webView : i0) {
                webView.M.getSettings().setMediaPlaybackRequiresUserGesture(enabled);
            }
        });
    }

    public static void setCameraAndMicrophoneEnabled(boolean enabled) {
        WebView.setCameraEnabled(enabled);
        WebView.setMicrophoneEnabled(enabled);
    }

    public static void setCameraEnabled(boolean enabled) {
        V = enabled;
    }

    /*
     * WARNING - void declaration
     */
    public static void setCookie(String cookieJson) {
        Object object;
        Object url;
        ArrayList<String> segments;
        long expirationDate;
        boolean httpOnly;
        block41: {
            void value;
            void name;
            ArrayList<String> arrayList;
            CharSequence domain;
            JSONObject cookie;
            block40: {
                CharSequence charSequence;
                JSONObject jSONObject;
                JSONObject jSONObject2 = jSONObject;
                jSONObject2(cookieJson);
                cookie = jSONObject2;
                String string = cookie.getString("Name");
                String string2 = cookie.getString("Value");
                String string3 = cookie.getString("Domain");
                domain = string3;
                boolean bl = domain.startsWith(".");
                if (bl) break block40;
                StringBuilder stringBuilder = charSequence;
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder();
                charSequence = ".";
                charSequence = stringBuilder2.append((String)charSequence);
                charSequence = ((StringBuilder)charSequence).append((String)domain);
                charSequence = ((StringBuilder)charSequence).toString();
                domain = charSequence;
            }
            String string = cookie.getString("Path");
            String path = string;
            boolean bl = cookie.getBoolean("Secure");
            boolean secure = bl;
            boolean bl2 = cookie.getBoolean("HttpOnly");
            httpOnly = bl2;
            long l2 = cookie.getLong("ExpirationDate");
            expirationDate = l2;
            ArrayList<String> arrayList2 = arrayList;
            arrayList2();
            segments = arrayList2;
            Object object2 = "%s=%s";
            Object[] objectArray = object2;
            object2 = new Object[2];
            Object[] objectArray2 = object2;
            objectArray2[0] = name;
            objectArray2[1] = value;
            segments.add(String.format((String)objectArray, (Object[])object2));
            Object object3 = object2;
            Object object4 = object3;
            ((StringBuilder)object3)();
            object2 = "https://";
            object2 = ((StringBuilder)object4).append((String)object2);
            object2 = ((StringBuilder)object2).append((String)domain);
            object2 = ((StringBuilder)object2).append(path);
            url = object2 = ((StringBuilder)object2).toString();
            if (!secure) break block41;
            segments.add("Secure");
        }
        if (httpOnly) {
            segments.add("HttpOnly");
        }
        if (expirationDate != 0L) {
            CharSequence charSequence = object;
            CharSequence charSequence2 = charSequence;
            ((StringBuilder)charSequence)();
            object = "Expires=";
            object = ((StringBuilder)charSequence2).append((String)object);
            CharSequence charSequence3 = object;
            Object object5 = object;
            ((Date)object5)(expirationDate * 1000L);
            object = ((Date)object5).toGMTString();
            object = ((StringBuilder)charSequence3).append((String)object);
            segments.add(((StringBuilder)object).toString());
        }
        object = "; ";
        object = TextUtils.join((CharSequence)object, segments);
        CharSequence cookieString = object;
        CookieManager cookieManager = CookieManager.getInstance();
        try {
            cookieManager.setCookie((String)url, (String)cookieString);
        }
        catch (JSONException cookie) {
            void ex;
            ex = ex;
            Log.e((String)TAG, (String)("A JSONException occurred while setting the cookie: " + ex));
        }
    }

    public static void setDrmEnabled(boolean enabled) {
        Y = enabled;
    }

    public static void setGeolocationEnabled(boolean enabled) {
        Z = enabled;
    }

    public static void setIgnoreCertificateErrors(boolean ignore) {
        a0 = ignore;
    }

    public static void setMicrophoneEnabled(boolean enabled) {
        b0 = enabled;
    }

    public static void setMidiSysexEnabled(boolean enabled) {
        c0 = enabled;
    }

    public static void setNativeParentView(ViewGroup viewGroup) {
        Log.i((String)TAG, (String)"The application called AndroidWebView.SetNativeParentView() to override the parent view. (This message is logged to aid Vuplex Support.)");
        d0 = viewGroup;
    }

    public static void setRemoteDebuggingEnabled(boolean enabled) {
        l l2 = enabled ? com.vuplex.webview.WebView$l.b : com.vuplex.webview.WebView$l.c;
        e0 = l2;
    }

    public static void setStorageEnabled(boolean enabled) {
        h0 = enabled;
    }

    private static native String gtifvs(String var0);

    private static String d(String param) {
        return WebView.gtifvs(param);
    }

    private static native boolean iet(String var0);

    private static boolean e(String param) {
        return WebView.iet(param);
    }

    private void a(boolean bringToFront) {
        if (this.M.getParent() != null) {
            return;
        }
        ViewGroup viewGroup = WebView.h();
        viewGroup.addView((View)this.M, 0);
        if (bringToFront) {
            this.M.bringToFront();
        }
    }

    private int b(int vuplexMouseButtonEnum) {
        switch (vuplexMouseButtonEnum) {
            default: {
                Log.w((String)TAG, (String)("Unrecognized mouse button: " + vuplexMouseButtonEnum));
                return 1;
            }
            case 2: {
                return 4;
            }
            case 1: {
                return 2;
            }
            case 0: 
        }
        return 1;
    }

    private String a(int mouseButton) {
        switch (mouseButton) {
            default: {
                Log.w((String)TAG, (String)("Unrecognized mouseButton enum value: " + mouseButton));
                return "left";
            }
            case 2: {
                return "middle";
            }
            case 1: {
                return "right";
            }
            case 0: 
        }
        return "left";
    }

    private boolean b() {
        a a2 = this.j;
        boolean bl = a2 != null && a2.f();
        return bl;
    }

    private void a(int eventType, int unscaledX, int unscaledY, int buttonState) {
        this.a(eventType, unscaledX, unscaledY, buttonState, 0, 0);
    }

    private void a(int eventType, int unscaledX, int unscaledY, int buttonState, int unscaledScrollDeltaX, int unscaledScrollDeltaY) {
        WebView.a(() -> {
            long verticalScrollFactor2;
            if (eventType == 0) {
                long l2;
                this.K = l2 = SystemClock.uptimeMillis();
            }
            MotionEvent.PointerProperties pointerProperties = new MotionEvent.PointerProperties();
            pointerProperties.id = 1776;
            pointerProperties.toolType = 3;
            MotionEvent.PointerCoords pointerCoords = new MotionEvent.PointerCoords();
            pointerCoords.x = unscaledX;
            pointerCoords.y = unscaledY;
            pointerCoords.pressure = 1.0f;
            pointerCoords.size = 1.0f;
            if (eventType == 8) {
                float verticalScrollFactor2 = 176.0f;
                float horizontalScrollFactor = 176.0f;
                if (Build.VERSION.SDK_INT >= 26) {
                    ViewConfiguration viewConfig = ViewConfiguration.get((Context)WebView.f());
                    verticalScrollFactor2 = viewConfig.getScaledVerticalScrollFactor();
                    horizontalScrollFactor = viewConfig.getScaledHorizontalScrollFactor();
                } else {
                    TypedValue outValue = new TypedValue();
                    Context context = WebView.f();
                    if (context.getTheme().resolveAttribute(16842829, outValue, true)) {
                        float scrollFactor;
                        verticalScrollFactor2 = scrollFactor = outValue.getDimension(context.getResources().getDisplayMetrics());
                        horizontalScrollFactor = scrollFactor;
                    }
                }
                float scaledScrollDeltaX = (float)(-unscaledScrollDeltaX) / horizontalScrollFactor;
                float scaledScrollDeltaY = (float)(-unscaledScrollDeltaY) / verticalScrollFactor2;
                pointerCoords.setAxisValue(10, scaledScrollDeltaX);
                pointerCoords.setAxisValue(9, scaledScrollDeltaY);
            }
            long l3 = verticalScrollFactor2 = this.K;
            verticalScrollFactor2 = SystemClock.uptimeMillis();
            View view = new MotionEvent.PointerProperties[1];
            View scaledScrollDeltaX = view;
            view[0] = pointerProperties;
            MotionEvent.PointerCoords[] pointerCoordsArray = new MotionEvent.PointerCoords[1];
            MotionEvent.PointerCoords[] pointerCoordsArray2 = pointerCoordsArray;
            pointerCoordsArray[0] = pointerCoords;
            MotionEvent event = MotionEvent.obtain((long)l3, (long)verticalScrollFactor2, (int)eventType, (int)1, (MotionEvent.PointerProperties[])scaledScrollDeltaX, (MotionEvent.PointerCoords[])pointerCoordsArray2, (int)0, (int)buttonState, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)8194, (int)0);
            if (eventType == 11 || eventType == 12) {
                WebView.a(event, buttonState);
            }
            boolean horizontalScrollFactor = Arrays.binarySearch(new int[]{0, 1, 2}, eventType) >= 0;
            boolean shouldDispatchAsTouchEvent = horizontalScrollFactor;
            scaledScrollDeltaX = this.p;
            if (scaledScrollDeltaX == null) {
                scaledScrollDeltaX = this.M;
            }
            View view2 = scaledScrollDeltaX;
            if (shouldDispatchAsTouchEvent) {
                view2.dispatchTouchEvent(event);
            } else {
                view2.dispatchGenericMotionEvent(event);
            }
        });
    }

    private void a(JSONObject message) {
        String string = message.toString();
        this.d("HandleDownloadProgressChanged", string);
    }

    private void a(String nativeErrorCode, String url) {
        Object[] objectArray = new Object[2];
        Object object = objectArray;
        objectArray[0] = nativeErrorCode;
        objectArray[1] = url;
        object = String.format("%s,%s", object);
        this.d("HandleLoadFailed", (String)object);
    }

    private void c() {
        this.h("HandleLoadStarted");
    }

    private void a(String serializedMessage) {
        this.d("HandleMessageEmitted", serializedMessage);
    }

    /*
     * WARNING - void declaration
     */
    private void b(String url) {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        JSONObject urlAction22 = jSONObject2;
        String string = "Type";
        String string2 = "LOAD";
        urlAction22.put(string, (Object)string2);
        urlAction22.put("Url", (Object)url);
        String string3 = string2;
        string3();
        String message = string3;
        message.put("urlAction", (Object)urlAction22);
        String string4 = "type";
        String string5 = "vuplex.webview.urlChanged";
        message.put(string4, (Object)string5);
        try {
            this.a(message.toString());
        }
        catch (JSONException urlAction22) {
            void e2;
            e2 = e2;
            Log.e((String)TAG, (String)("An unexpected exception occurred while emitting the UrlChanged event: " + e2));
        }
    }

    private void c(String javaScript) {
        this.executeJavaScript(javaScript, null);
    }

    private Bitmap d() {
        Bitmap bitmap = Bitmap.createBitmap((int)this.O, (int)this.r, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        float f2 = -this.M.getScrollY();
        canvas.translate((float)(-this.M.getScrollX()), f2);
        this.a(canvas);
        return bitmap;
    }

    static String e() {
        if (T == null) {
            String mobileUserAgent = WebSettings.getDefaultUserAgent((Context)WebView.f());
            Matcher matcher = Pattern.compile("Chrome/([0-9.]*) ").matcher(mobileUserAgent);
            String string = matcher.find() ? matcher.group(1) : "110.0.0.0";
            T = string;
        }
        return T;
    }

    protected static Context f() {
        return UnityPlayer.currentActivity;
    }

    private static List<String> b(String url, String cookieName) {
        String cookieString = CookieManager.getInstance().getCookie(url);
        if (cookieString == null) {
            return new ArrayList<String>();
        }
        String[] nameValuePairs = cookieString.split("; ");
        if (cookieName == null) {
            return Arrays.asList(nameValuePairs);
        }
        ArrayList<String> matchingNameValuePairs = new ArrayList<String>();
        for (String nameValuePair : nameValuePairs) {
            if (!nameValuePair.startsWith(cookieName + "=")) continue;
            matchingNameValuePairs.add(nameValuePair);
        }
        return matchingNameValuePairs;
    }

    static String g() {
        if (U == null) {
            String chromiumVersion = WebView.e();
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = chromiumVersion;
            U = String.format("Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s Safari/537.36", objectArray2);
        }
        return U;
    }

    private static String[] a(Uri uri) {
        String host = uri.getHost();
        String[] domainSegments = host.split("\\.");
        if (domainSegments.length <= 2) {
            return new String[0];
        }
        boolean isIPv4Address = domainSegments[0].matches("\\d+");
        if (isIPv4Address) {
            return new String[0];
        }
        ArrayList<String> parentDomains = new ArrayList<String>();
        for (int i2 = 1; i2 < domainSegments.length - 1; ++i2) {
            int n2 = domainSegments.length;
            Object[] segmentsToInclude = Arrays.copyOfRange(domainSegments, i2, n2);
            String domain = TextUtils.join((CharSequence)".", (Object[])segmentsToInclude);
            parentDomains.add(0, domain);
        }
        return parentDomains.toArray(new String[0]);
    }

    private static ViewGroup h() {
        ViewGroup viewGroup = d0;
        if (viewGroup != null) {
            return viewGroup;
        }
        return (ViewGroup)UnityPlayer.currentActivity.getWindow().getDecorView().getRootView();
    }

    private int c(int unscaledXOrY) {
        return (int)((float)unscaledXOrY / this.G);
    }

    private void b(int x, int y, int width, int height) {
        WebView thisInstance = this;
        WebView.a(() -> {
            e e2;
            m m2;
            boolean shouldEnableDevTools = this.m();
            if (shouldEnableDevTools) {
                android.webkit.WebView.setWebContentsDebuggingEnabled((boolean)true);
            }
            this.M = this.a();
            i0.add(thisInstance);
            this.M.setX((float)x);
            this.M.setY((float)y);
            this.a(width, height);
            if (W) {
                this.M.clearCache(true);
                W = false;
            }
            this.b(true);
            this.M.setFindListener((WebView.FindListener)thisInstance);
            WebSettings settings = this.M.getSettings();
            settings.setJavaScriptEnabled(true);
            settings.setUserAgentString(X);
            settings.setAllowUniversalAccessFromFileURLs(true);
            settings.setMixedContentMode(2);
            settings.setAllowFileAccess(true);
            settings.setJavaScriptCanOpenWindowsAutomatically(true);
            settings.setDomStorageEnabled(h0);
            settings.setAppCacheEnabled(h0);
            settings.setSavePassword(h0);
            settings.setSaveFormData(h0);
            if (!h0) {
                settings.setCacheMode(2);
            }
            CookieManager.getInstance().setAcceptCookie(h0);
            int n2 = Build.VERSION.SDK_INT;
            if (n2 >= 21) {
                CookieManager.getInstance().setAcceptThirdPartyCookies(this.M, h0);
            }
            if (!V && !b0) {
                boolean bl = S;
                settings.setMediaPlaybackRequiresUserGesture(bl ^ true);
            } else {
                settings.setMediaPlaybackRequiresUserGesture(false);
            }
            if (n2 >= 26) {
                n n3;
                m2 = n3;
                n3 = new n();
            } else {
                m m3;
                m2 = m3;
                m3 = new m();
            }
            m webViewClient = m2;
            this.M.setWebViewClient((WebViewClient)webViewClient);
            this.l();
            e e3 = e2;
            e2 = new e(thisInstance);
            this.N = e3;
            this.M.addJavascriptInterface((Object)e3, "_vuplexBridge");
            this.a(this.p());
            boolean bl = this.F != null;
            boolean isPopup = bl;
            if (shouldEnableDevTools) {
                if (isPopup) {
                    this.i = true;
                } else {
                    this.i();
                }
            } else {
                this.h("HandleInitFinished");
            }
            if (isPopup) {
                WebView.WebViewTransport transport = (WebView.WebViewTransport)this.F.obj;
                transport.setWebView(this.M);
                this.F.sendToTarget();
            }
        });
    }

    private boolean f(String newUrl) {
        String[] newUrlSegments;
        String newUrlWithoutFragment;
        String previousUrl;
        String[] previousUrlSegments;
        String previousUrlWithoutFragment;
        boolean isOnlyFragmentChange;
        WebBackForwardList backForwardList = this.M.copyBackForwardList();
        String backForwardListCurrentUrl = backForwardList.getCurrentItem().getUrl();
        if (!newUrl.equals(backForwardListCurrentUrl)) {
            return false;
        }
        int historyIndex = backForwardList.getCurrentIndex();
        return historyIndex > 1 && (isOnlyFragmentChange = (previousUrlWithoutFragment = (previousUrlSegments = (previousUrl = backForwardList.getItemAtIndex(historyIndex - 1).getUrl()).split("#"))[0]).equals(newUrlWithoutFragment = (newUrlSegments = newUrl.split("#"))[0]));
    }

    private void c(String jsFunctionName, String eventName) {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = jsFunctionName;
        objectArray[1] = eventName;
        Log.w((String)TAG, (String)String.format("The web page tried to show a dialog popup using the JavaScript window.%s() API, but 3D WebView is unable to show those native popups when XR is enabled. If you want to display these popups in your application, you can use the AndroidWebView.%s event to achieve that.", objectArray2));
    }

    private void j() {
        ViewGroup parent = (ViewGroup)this.M.getParent();
        if (parent != null) {
            parent.removeView((View)this.M);
        }
    }

    private void a(int width, int height) {
        int n2;
        this.O = width;
        this.r = height;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(width, height);
        layoutParams.setMargins(0, 0, 0, 0);
        this.M.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        android.webkit.WebView webView = this.M;
        int n3 = n2 = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
        n2 = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
        webView.measure(n3, n2);
        if (!this.p()) {
            this.k();
        }
    }

    private void k() {
        View view = this.p;
        if (view == null) {
            return;
        }
        int width = this.O;
        int height = this.r;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(width, height);
        layoutParams.setMargins(0, 0, 0, 0);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        int n2 = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
        view.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), n2);
    }

    protected static void a(Runnable runnable) {
        UnityPlayer.currentActivity.runOnUiThread(runnable);
    }

    private void h(String methodName) {
        this.d(methodName, "");
    }

    private String a(ConsoleMessage.MessageLevel level) {
        switch (com.vuplex.webview.WebView$f.a[level.ordinal()]) {
            default: {
                return "LOG";
            }
            case 4: {
                return "WARNING";
            }
            case 3: {
                return "ERROR";
            }
            case 1: 
            case 2: 
        }
        return "DEBUG";
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean a(MotionEvent motionEvent, int actionButton) {
        void var2_13;
        try {
            Method method = f0;
            if (method == null) {
                Method method2;
                Class<Integer> clazz = Integer.TYPE;
                Class[] classArray = new Class[]{clazz};
                Class<MotionEvent> clazz2 = MotionEvent.class;
                f0 = method2 = clazz2.getMethod("setActionButton", classArray);
            }
            Method method3 = f0;
            Object[] objectArray = new Object[1];
            Integer n2 = actionButton;
            objectArray[0] = n2;
            method3.invoke((Object)motionEvent, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return true;
        void var2_14 = var2_13;
        Log.e((String)TAG, (String)"Cannot set action button on MotionEvent", (Throwable)var2_14);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void l() {
        void webChromeClient;
        g g2;
        if (this.o) {
            i i2;
            g2 = i2;
            i2 = new i();
        } else {
            g g3;
            g2 = g3;
            g3 = new g();
        }
        this.M.setWebChromeClient((WebChromeClient)webChromeClient);
    }

    private void b(boolean transparent) {
        android.webkit.WebView webView = this.M;
        int n2 = transparent ? 0 : -1;
        webView.setBackgroundColor(n2);
    }

    private void a(float scale, boolean scaleSetByZoom) {
        WebView.a(() -> {
            this.G = scale;
            this.H = scaleSetByZoom;
            int scaleInPercent = (int)(scale * 100.0f);
            this.M.setInitialScale(scaleInPercent);
        });
    }

    private String i(String url) {
        String streamingAssetsPrefix = "!/assets/";
        if ((url.startsWith("file:") || url.startsWith("jar:")) && url.contains(streamingAssetsPrefix)) {
            return "file:///android_asset/" + url.substring(url.indexOf(streamingAssetsPrefix) + streamingAssetsPrefix.length());
        }
        return url;
    }

    private void q() {
        String string = "%s;window.__initVuplex({ defaultBackgroundEnabled: %s, overrideViewportMetaTag: %s, enableFocusedInputFieldEvents: %s, enableInputTypeWorkaround: %s, enableSelectElementManager: %s, removeAnchorTargetAttributes: %s });";
        Object[] objectArray = new Object[7];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "if(typeof Object.assign!=\"function\"){Object.defineProperty(Object,\"assign\",{value:function e(t){\"use strict\";if(t==null){throw new TypeError(\"Cannot convert undefined or null to object\")}var n=Object(t);for(var r=1;r<arguments.length;r++){var i=arguments[r];if(i!=null){for(var o in i){if(Object.prototype.hasOwnProperty.call(i,o)){n[o]=i[o]}}}}return n},writable:true,configurable:true})}var _vuplexSystem;(function(e){var s={};var u={};function t(e,t,n){u[e]={deps:t,factory:n}}e.register=t;function n(e,t){s[e]=t}e.registerExternal=n;function l(e){if(e in s)return s[e];return r(e)}e.require=l;function c(e){var t=l(e);return Promise.resolve(t)}function r(e){if(!(e in u))throw new Error(\"Cannot resolve '\"+e+\"'\");var t=u[e];var n={};s[e]=n;function r(e,t){n[e]=t}var i=t.factory(r,{id:e,import:c});for(var o=0;o<t.deps.length;o++){var a=t.deps[o];i.setters[o](l(a))}i.execute();return n}})(_vuplexSystem||(_vuplexSystem={}));var __extends=this&&this.__extends||function(){var r=function(e,t){r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)if(Object.prototype.hasOwnProperty.call(t,n))e[n]=t[n]};return r(e,t)};return function(e,t){if(typeof t!==\"function\"&&t!==null)throw new TypeError(\"Class extends value \"+String(t)+\" is not a constructor or null\");r(e,t);function n(){this.constructor=e}e.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}}();var __awaiter=this&&this.__awaiter||function(e,a,n,s){function u(t){return t instanceof n?t:new n(function(e){e(t)})}return new(n||(n=Promise))(function(t,n){function r(e){try{o(s.next(e))}catch(e){n(e)}}function i(e){try{o(s[\"throw\"](e))}catch(e){n(e)}}function o(e){e.done?t(e.value):u(e.value).then(r,i)}o((s=s.apply(e,a||[])).next())})};var __generator=this&&this.__generator||function(e,n){var r={label:0,sent:function(){if(a[0]&1)throw a[1];return a[1]},trys:[],ops:[]},i,o,a,t;return t={next:s(0),throw:s(1),return:s(2)},typeof Symbol===\"function\"&&(t[Symbol.iterator]=function(){return this}),t;function s(t){return function(e){return u([t,e])}}function u(t){if(i)throw new TypeError(\"Generator is already executing.\");while(r)try{if(i=1,o&&(a=t[0]&2?o[\"return\"]:t[0]?o[\"throw\"]||((a=o[\"return\"])&&a.call(o),0):o.next)&&!(a=a.call(o,t[1])).done)return a;if(o=0,a)t=[t[0]&2,a.value];switch(t[0]){case 0:case 1:a=t;break;case 4:r.label++;return{value:t[1],done:false};case 5:r.label++;o=t[1];t=[0];continue;case 7:t=r.ops.pop();r.trys.pop();continue;default:if(!(a=r.trys,a=a.length>0&&a[a.length-1])&&(t[0]===6||t[0]===2)){r=0;continue}if(t[0]===3&&(!a||t[1]>a[0]&&t[1]<a[3])){r.label=t[1];break}if(t[0]===6&&r.label<a[1]){r.label=a[1];a=t;break}if(a&&r.label<a[2]){r.label=a[2];r.ops.push(t);break}if(a[2])r.ops.pop();r.trys.pop();continue}t=n.call(e,r)}catch(e){t=[6,e];o=0}finally{i=a=0}if(t[0]&5)throw t[1];return{value:t[0]?t[1]:void 0,done:true}}};_vuplexSystem.register(\"utils/EventEmitter\",[],function(e,t){\"use strict\";var n;var r=t&&t.id;return{setters:[],execute:function(){n=function(){function e(){this._listeners={}}e.prototype.addListener=function(e,t){if(!this._listeners[e]){this._listeners[e]=[]}if(this._listeners[e].indexOf(t)===-1){this._listeners[e].push(t)}};e.prototype.emit=function(t){var e=[];for(var n=1;n<arguments.length;n++){e[n-1]=arguments[n]}if(!this._listeners[t]){return}for(var r=0,i=this._listeners[t];r<i.length;r++){var o=i[r];try{o.apply(void 0,e)}catch(e){console.error(\"An error occurred while invoking the '\"+t+\"' event handler.\",e)}}};e.prototype.removeListener=function(e,t){if(!this._listeners[e]){return}var n=this._listeners[e].indexOf(t);if(n!==-1){this._listeners[e].splice(n,1)}};return e}();e(\"default\",n)}}});_vuplexSystem.register(\"IBridge\",[],function(e,t){\"use strict\";var n=t&&t.id;return{setters:[],execute:function(){}}});_vuplexSystem.register(\"BaseBridge\",[\"utils/EventEmitter\"],function(e,t){\"use strict\";var n,r;var i=t&&t.id;return{setters:[function(e){n=e}],execute:function(){r=function(){function e(){this._eventEmitter=new n.default;this._eventResponseResolveFunctions={}}e.prototype.addEventListener=function(e,t){this._eventEmitter.addListener(e,t)};e.prototype.removeEventListener=function(e,t){this._eventEmitter.removeListener(e,t)};e.prototype.postMessageWithResponse=function(n){var r=this;var i;do{i=Math.random().toString()}while(i in this._eventResponseResolveFunctions);return new window.Promise(function(e,t){r._eventResponseResolveFunctions[i]=e;n=Object.assign({responseId:i},n);setTimeout(t,1e3);r.postMessage(n)}).then(function(e){delete r._eventResponseResolveFunctions[i];return e}).catch(function(){delete r._eventResponseResolveFunctions[i];throw new Error(\"The native module didn't respond to the event in time.\")})};e.prototype._emit=function(e,t){this._eventEmitter.emit(e,t)};e.prototype._respondToEvent=function(e){var t=e.responseId,n=e.value;var r=this._eventResponseResolveFunctions[t];if(r){r(n)}};return e}();e(\"default\",r)}}});_vuplexSystem.register(\"android/AndroidBridge\",[\"BaseBridge\"],function(e,t){\"use strict\";var n,r;var i=t&&t.id;return{setters:[function(e){n=e}],execute:function(){r=function(e){__extends(t,e);function t(){return e!==null&&e.apply(this,arguments)||this}t.prototype.postMessage=function(e){var t=typeof e===\"string\"?e:JSON.stringify(e);window._vuplexBridge.postMessage(t)};return t}(n.default);e(\"default\",r)}}});_vuplexSystem.register(\"IFrameBridge\",[\"BaseBridge\"],function(e,t){\"use strict\";var n,r;var i=t&&t.id;return{setters:[function(e){n=e}],execute:function(){r=function(e){__extends(t,e);function t(){return e!==null&&e.apply(this,arguments)||this}t.prototype.postMessage=function(e){};return t}(n.default);e(\"default\",r)}}});_vuplexSystem.register(\"MessageType\",[],function(e,t){\"use strict\";var n;var r=t&&t.id;return{setters:[],execute:function(){(function(e){e[\"FocusedInputFieldChanged\"]=\"vuplex.webview.focusedInputFieldChanged\";e[\"PageTransparencyDetermined\"]=\"vuplex.webview.pageTransparencyDetermined\";e[\"TitleChanged\"]=\"vuplex.webview.titleChanged\";e[\"TransparencyBlockedWarning\"]=\"vuplex.webview.transparencyBlockedWarning\";e[\"UrlChanged\"]=\"vuplex.webview.urlChanged\"})(n||(n={}));e(\"default\",n)}}});_vuplexSystem.register(\"utils/flattenPrototypes\",[],function(e,t){\"use strict\";var n=t&&t.id;function r(e,t){var n,r;while(t.constructor.name!==\"Object\"){for(var i=0,o=Object.getOwnPropertyNames(t);i<o.length;i++){var a=o[i];var s=Object.getOwnPropertyDescriptor(t,a);if(s.get||s.set){(n=s.get)===null||n===void 0?void 0:n.bind(e);(r=s.set)===null||r===void 0?void 0:r.bind(e)}else{var u=t[a];if(typeof u===\"function\"&&a!==\"constructor\"){e[a]=u.bind(e)}}}t=Object.getPrototypeOf(t)}}e(\"default\",r);return{setters:[],execute:function(){}}});_vuplexSystem.register(\"UrlActionType\",[],function(e,t){\"use strict\";var n;var r=t&&t.id;return{setters:[],execute:function(){(function(e){e[\"Load\"]=\"LOAD\";e[\"PushState\"]=\"PUSH_STATE\";e[\"ReplaceState\"]=\"REPLACE_STATE\";e[\"HashChange\"]=\"HASH_CHANGE\"})(n||(n={}));e(\"default\",n)}}});_vuplexSystem.register(\"FocusedInputFieldType\",[],function(e,t){\"use strict\";var n;var r=t&&t.id;return{setters:[],execute:function(){(function(e){e[\"Text\"]=\"TEXT\";e[\"IFrame\"]=\"IFRAME\";e[\"None\"]=\"NONE\"})(n||(n={}));e(\"default\",n)}}});_vuplexSystem.register(\"isTextInputOrTextarea\",[],function(e,t){\"use strict\";var r;var n=t&&t.id;function i(e,t){if(e instanceof t.HTMLInputElement){var n=r[e.type.toLowerCase()];return!n}return e instanceof t.HTMLTextAreaElement}e(\"default\",i);return{setters:[],execute:function(){r={button:true,checkbox:true,color:true,file:true,hidden:true,image:true,radio:true,range:true,reset:true,submit:true}}}});_vuplexSystem.register(\"getActiveElement\",[],function(e,t){\"use strict\";var n=t&&t.id;function r(e){return i(e.document.activeElement)}e(\"default\",r);function i(e){if(e===null||e===void 0?void 0:e.shadowRoot){return i(e.shadowRoot.activeElement)}return e}return{setters:[],execute:function(){}}});_vuplexSystem.register(\"focusedElementIsEditable\",[\"isTextInputOrTextarea\",\"getActiveElement\"],function(e,t){\"use strict\";var n,r;var i=t&&t.id;function o(e){var t=r.default(e);return t&&(n.default(t,e)||t.isContentEditable)}e(\"default\",o);return{setters:[function(e){n=e},function(e){r=e}],execute:function(){}}});_vuplexSystem.register(\"checkIfPageBackgroundIsSet\",[],function(e,t){\"use strict\";var n=t&&t.id;function r(e){var t=[e.document.body,e.document.documentElement].filter(function(e){return e});for(var n=0,r=t;n<r.length;n++){var i=r[n];var o=s(e,i);if(o.backgroundIsSet){return o}}return{backgroundIsSet:false}}e(\"default\",r);function a(e,t,n){var r=\"<\"+e.tagName.toLowerCase()+\">\";return\"The page's \"+r+\" element \"+t+' is set to \"'+n+'\".'}function s(e,t){var n=e.getComputedStyle(t);var r=n.background,i=n.backgroundImage,o=n.backgroundColor;if(i!==\"none\"){return{backgroundIsSet:true,details:a(t,\"backgroundImage\",i)}}if(r&&r.indexOf(\"rgba(0, 0, 0, 0) none\")!==0){return{backgroundIsSet:true,details:a(t,\"background\",r)}}if(!(!o||o.indexOf(\"rgba(0, 0, 0, 0)\")===0||o===\"transparent\")){return{backgroundIsSet:true,details:a(t,\"backgroundColor\",o)}}return{backgroundIsSet:false}}return{setters:[],execute:function(){}}});_vuplexSystem.register(\"BrowserAgent\",[\"utils/EventEmitter\",\"IFrameBridge\",\"MessageType\",\"utils/flattenPrototypes\",\"UrlActionType\",\"FocusedInputFieldType\",\"focusedElementIsEditable\",\"getActiveElement\",\"checkIfPageBackgroundIsSet\"],function(e,t){\"use strict\";var n,i,a,s,u,l,c,d,o,r;var f=t&&t.id;return{setters:[function(e){n=e},function(e){i=e},function(e){a=e},function(e){s=e},function(e){u=e},function(e){l=e},function(e){c=e},function(e){d=e},function(e){o=e}],execute:function(){r=function(n){__extends(r,n);function r(e,t){var o=n.call(this)||this;o._consoleApiPatched=false;o._consoleMessageEventsEnabled=false;o._defaultBackgroundEnabled=true;o._focusedInputField=null;o._focusedInputFieldIntervalToken=0;o._isInIframe=parent!==window;o._checkFocusedInputField=function(){var e=d.default(o._window);var t=e instanceof HTMLIFrameElement;var n=c.default(o._window);var r=n||t?e:null;if(o._focusedInputField!==r){if(o._focusedInputField){o._focusedInputField.removeEventListener(\"click\",o._handleFocusedInputFieldClicked)}if(r){r.addEventListener(\"click\",o._handleFocusedInputFieldClicked)}var i=t?l.default.IFrame:n?l.default.Text:l.default.None;o._focusedInputField=r;o._bridge.postMessage({type:a.default.FocusedInputFieldChanged,value:i})}};o._handleFocusedInputFieldClicked=function(){o._bridge.postMessage({type:a.default.FocusedInputFieldChanged,value:l.default.Text})};o._consoleMessageEventsEnabled=!!(t===null||t===void 0?void 0:t.enableConsoleMessageEvents);o._windowReference=t===null||t===void 0?void 0:t.window;o._patchConsoleApiIfNeeded();if((t===null||t===void 0?void 0:t.defaultBackgroundEnabled)!==undefined){o._defaultBackgroundEnabled=t.defaultBackgroundEnabled}s.default(o,r.prototype);if(o._isInIframe){o._bridge=new i.default}else{o._bridge=e}if(o._document.readyState===\"loading\"||!o._document.head){o._document.addEventListener(\"DOMContentLoaded\",function(){o._performPostDomLoadInitialization(t===null||t===void 0?void 0:t.enableFocusedInputFieldEvents)})}else{o._performPostDomLoadInitialization(t===null||t===void 0?void 0:t.enableFocusedInputFieldEvents)}if(o._isInMainFrame){o._emitTitleChangeIfNeeded();o._window.setInterval(o._emitTitleChangeIfNeeded.bind(o),200);o._emitUrlChange(u.default.Load);o._watchForUrlChanges()}return o}r.prototype.setConsoleMessageEventsEnabled=function(e){this._consoleMessageEventsEnabled=e;this._patchConsoleApiIfNeeded()};r.prototype.setDefaultBackgroundEnabled=function(e){this._defaultBackgroundEnabled=e;if(!e){this._warnIfTransparencyIsBlocked()}};r.prototype.setFocusedInputFieldEventsEnabled=function(e){if(e&&!this._focusedInputFieldIntervalToken){this._focusedInputFieldIntervalToken=this._window.setInterval(this._checkFocusedInputField,200)}};Object.defineProperty(r.prototype,\"_document\",{get:function(){return this._window.document},enumerable:false,configurable:true});Object.defineProperty(r.prototype,\"_window\",{get:function(){return this._windowReference||window},enumerable:false,configurable:true});r.prototype._emitTitleChangeIfNeeded=function(){var e=this._document.title,t=e===void 0?\"\":e;if(this._title===t){return}this._title=t;this._bridge.postMessage({type:a.default.TitleChanged,value:t})};r.prototype._emitTransparentMetaTagStatus=function(){this._bridge.postMessage({type:a.default.PageTransparencyDetermined,value:this._transparencyEnabledViaMetaTag()})};r.prototype._emitUrlChange=function(e){try{var t=this._document.URL;if(t.indexOf(\"chrome-error://\")===0){return}if(t.indexOf(\"about:\")===0){return}if(t.indexOf(\"ms-local-stream://\")===0){return}if(t.indexOf(\".pdf?file=\")!==-1){return}this._bridge.postMessage({type:a.default.UrlChanged,urlAction:{Url:t,Title:this._document.title,Type:e}})}catch(e){console.error(\"An error occurred while handling the URL change.\",e)}};Object.defineProperty(r.prototype,\"_isInMainFrame\",{get:function(){return parent===window},enumerable:false,configurable:true});r.prototype._onHashChange=function(){this._emitUrlChange(u.default.HashChange)};r.prototype._onPushState=function(){this._emitUrlChange(u.default.PushState)};r.prototype._onReplaceState=function(){this._emitUrlChange(u.default.ReplaceState)};r.prototype._transparencyEnabledViaMetaTag=function(){var e=this._document.head.getElementsByTagName(\"meta\");var t=Array.prototype.filter.call(e,function(e){return e.getAttribute(\"name\")===\"transparent\"})[0];return!!t&&t.getAttribute(\"content\")===\"true\"};r.prototype._patchConsoleApiIfNeeded=function(){if(this._consoleApiPatched||!this._consoleMessageEventsEnabled){return}this._consoleApiPatched=true;this._patchConsoleMethod(\"log\",\"LOG\");this._patchConsoleMethod(\"info\",\"LOG\");this._patchConsoleMethod(\"debug\",\"DEBUG\");this._patchConsoleMethod(\"error\",\"ERROR\");this._patchConsoleMethod(\"warn\",\"WARNING\")};r.prototype._patchConsoleMethod=function(e,r){var i=this;var o=this._window.console[e].bind(this._window.console);this._window.console[e]=function(){var e=[];for(var t=0;t<arguments.length;t++){e[t]=arguments[t]}if(i._consoleMessageEventsEnabled){try{var n=e.map(function(e){return typeof e===\"object\"&&!(e instanceof i._window.Error)?JSON.stringify(e):e}).join(\", \");i._bridge.postMessage({type:\"vuplex.webview.consoleMessageLogged\",level:r,message:n})}catch(e){}}o.apply(void 0,e)}};r.prototype._performPostDomLoadInitialization=function(e){if(this._isInMainFrame){this._emitTransparentMetaTagStatus();this._warnIfTransparencyIsBlocked()}if(e){this.setFocusedInputFieldEventsEnabled(true)}};r.prototype._warnIfTransparencyIsBlocked=function(){var e=this._transparencyEnabledViaMetaTag()||!this._defaultBackgroundEnabled;if(!e){return}var t=o.default(this._window),n=t.backgroundIsSet,r=t.details;if(n){this._bridge.postMessage({type:a.default.TransparencyBlockedWarning,value:r})}};r.prototype._watchForUrlChanges=function(){var r=this;var i=this._window.history.pushState;this._window.history.pushState=function(){var e=[];for(var t=0;t<arguments.length;t++){e[t]=arguments[t]}var n=i.apply(r._window.history,e);r._onPushState();return n};var o=this._window.history.replaceState;this._window.history.replaceState=function(){var e=[];for(var t=0;t<arguments.length;t++){e[t]=arguments[t]}var n=o.apply(r._window.history,e);r._onReplaceState();return n};this._window.addEventListener(\"hashchange\",this._onHashChange.bind(this));this._window.addEventListener(\"yt-navigate-finish\",this._onPushState.bind(this))};return r}(n.default);e(\"default\",r)}}});_vuplexSystem.register(\"initBrowserAgent\",[\"BrowserAgent\"],function(e,t){\"use strict\";var i;var n=t&&t.id;function r(e,t){var n;var r=((n=t===null||t===void 0?void 0:t.browserAgentOptions)===null||n===void 0?void 0:n.window)||window;if(r.vuplex&&r._vuplexInternal){return}r.vuplex=e;r._vuplexInternal={browserAgent:new i.default(e,t===null||t===void 0?void 0:t.browserAgentOptions)};if(t===null||t===void 0?void 0:t.optionalComponents){Object.assign(r._vuplexInternal,t===null||t===void 0?void 0:t.optionalComponents)}r.dispatchEvent(new Event(\"vuplexready\"))}e(\"default\",r);return{setters:[function(e){i=e}],execute:function(){}}});_vuplexSystem.register(\"IFramePostMessageDomain\",[],function(e,t){\"use strict\";var n;var r=t&&t.id;return{setters:[],execute:function(){(function(e){e[\"IFrameBridgeDownstream\"]=\"vuplex.iframeBridgeDownstream\";e[\"IFrameBridgeUpstream\"]=\"vuplex.iframeBridgeUpstream\"})(n||(n={}));e(\"default\",n)}}});_vuplexSystem.register(\"optional/KeyboardInputManager\",[\"isTextInputOrTextarea\",\"IFramePostMessageDomain\",\"focusedElementIsEditable\"],function(e,t){\"use strict\";var a,r,p,i,n;var o=t&&t.id;return{setters:[function(e){a=e},function(e){r=e},function(e){p=e}],execute:function(){i=\"vuplex.webview.sendKey\";n=function(){function e(e){var n=this;this._textInputEventsEnabled=false;this._handleIFrameMessage=function(e){if(!e.data){return}var t=e.data.message;if(e.data.domain===r.default.IFrameBridgeDownstream&&t.type===i){n.sendKey(t.input)}};this._window=(e===null||e===void 0?void 0:e.window)||window;this._textInputEventsEnabled=!!(e===null||e===void 0?void 0:e.enableTextInputEvents);this._window.addEventListener(\"message\",this._handleIFrameMessage)}e.prototype.sendKey=function(e){if(this._document.activeElement instanceof this._window.HTMLIFrameElement){this._document.activeElement.contentWindow.postMessage({domain:r.default.IFrameBridgeDownstream,message:{type:i,input:e}},\"*\");return}if(e===\"Backspace\"){e=\"\\b\"}else if(e===\"Enter\"){e=\"\\n\"}var t=Array.from(e).length;if(t===1){this._dispatchCharacter(e);return}if(p.default(this._window)&&(e===\"ArrowLeft\"||e===\"ArrowRight\")){this._dispatchCharacter(e);return}switch(e){case\"ArrowUp\":this._window.scrollBy(0,-50);break;case\"ArrowDown\":this._window.scrollBy(0,50);break;case\"ArrowLeft\":this._window.scrollBy(-50,0);break;case\"ArrowRight\":this._window.scrollBy(50,0);break}};Object.defineProperty(e.prototype,\"_document\",{get:function(){return this._window.document},enumerable:false,configurable:true});e.prototype._dispatchCharacter=function(e){if(e===\"\\n\"&&this._document.activeElement instanceof this._window.HTMLInputElement){var t=this._getFocusedForm();if(t){var n=t.dispatchEvent(new Event(\"submit\",{cancelable:true}));if(n){t.submit()}}else{this._dispatchKeyPressEvents(this._document.activeElement,\"\\r\")}return}if(this._document.activeElement){this._dispatchKeyPressEvents(this._document.activeElement,e)}var r=this._document.activeElement;if(!p.default(this._window)){return}var i=this._getSelection(r),o=i.selectionStart,a=i.selectionEnd;var s=this._getTextValue(r);if(e===\"\\b\"){var u=o===a&&o===0;if(u){return}var l=o!==a;if(l){var c=this._spliceString(s,o,a-o,\"\");this._setTextValue(r,c);this._setSelection(r,o,o)}else{var c=this._spliceString(s,o-1,1,\"\");this._setTextValue(r,c);var d=o-1;this._setSelection(r,d,d)}}else if(e===\"ArrowLeft\"){if(o===a){var f=Math.max(o-1,0);this._setSelection(r,f,f)}else{this._setSelection(r,o,o)}}else if(e===\"ArrowRight\"){if(o===a){var f=Math.min(a+1,s.length);this._setSelection(r,f,f)}else{this._setSelection(r,a,a)}}else{var c=this._spliceString(s,o,a-o,e);this._setTextValue(r,c);var d=o+1;this._setSelection(r,d,d)}};e.prototype._dispatchKeyboardEvent=function(e,t,n){var r=n.charCodeAt(0);var i=new KeyboardEvent(t,{key:n,keyCode:r,bubbles:true,cancelable:true});Object.defineProperty(i,\"keyCode\",{value:r,writable:false});e.dispatchEvent(i)};e.prototype._dispatchKeyPressEvents=function(e,t){this._dispatchKeyboardEvent(e,\"keydown\",t);this._dispatchKeyboardEvent(e,\"keypress\",t);if(this._textInputEventsEnabled){var n=this._document.createEvent(\"TextEvent\");n.initTextEvent(\"textInput\",true,true,this._window,t,0,\"en-US\");e.dispatchEvent(n)}this._dispatchKeyboardEvent(e,\"keyup\",t)};e.prototype._getFocusedForm=function(){var e=this._document.activeElement||null;while(e){if(e instanceof this._window.HTMLFormElement){return e}e=e.parentElement}return null};e.prototype._getSelection=function(e){if(a.default(e,this._window)){return{selectionStart:e.selectionStart||0,selectionEnd:e.selectionEnd||0}}var t=this._window.getSelection();if(t&&t.rangeCount){var n=t.getRangeAt(0);if(n.commonAncestorContainer.parentNode==e){return{selectionStart:n.startOffset,selectionEnd:n.endOffset}}}return{selectionStart:0,selectionEnd:0}};e.prototype._getTextValue=function(e){if(a.default(e,this._window)){return e.value}return e.innerText||\"\"};e.prototype._setSelection=function(e,t,n){if(a.default(e,this._window)){e.setSelectionRange(t,n);return}var r=this._document.createRange();var i=this._window.getSelection();var o=e.childNodes[0];r.setStart(o,t);r.setStart(o,n);if(i){i.removeAllRanges();i.addRange(r)}};e.prototype._setTextValue=function(e,t){if(e instanceof this._window.HTMLInputElement){Object.getOwnPropertyDescriptor(this._window.HTMLInputElement.prototype,\"value\").set.call(e,t)}else if(e instanceof this._window.HTMLTextAreaElement){Object.getOwnPropertyDescriptor(this._window.HTMLTextAreaElement.prototype,\"value\").set.call(e,t)}else{e.innerText=t}e.dispatchEvent(new Event(\"input\",{bubbles:true}))};e.prototype._spliceString=function(e,t,n,r){return e.slice(0,t)+r+e.slice(t+Math.abs(n))};return e}();e(\"default\",n)}}});_vuplexSystem.register(\"utils/arrayFrom\",[],function(e,t){\"use strict\";var n=t&&t.id;function r(e){var t=[];for(var n=0;n<e.length;n++){t.push(e[n])}return t}e(\"default\",r);return{setters:[],execute:function(){}}});_vuplexSystem.register(\"optional/SelectElementManager\",[\"utils/arrayFrom\"],function(e,t){\"use strict\";var v,o,h,n;var r=t&&t.id;function g(e,t,n,r){var i=document.createElement(\"vuplex-dropdown-option\");i.innerText=e.innerText;var o=window.getComputedStyle(t);var a=o.font,s=o.fontSize,u=o.fontWeight;var l=\"#1e1e1e\";var c={font:a,fontSize:s,fontWeight:u,display:\"block\",padding:\"6px 10px\",color:l,cursor:\"default\"};Object.assign(i.style,c);var d={backgroundColor:\"#1275ff\",color:\"white\"};i.onclick=function(){Object.assign(i.style,d);t.value=e.value;t.dispatchEvent(new Event(\"input\",{bubbles:true}));t.dispatchEvent(new Event(\"change\",{bubbles:true}))};i.onmouseenter=function(){Object.assign(i.style,d)};i.onmouseleave=function(){Object.assign(i.style,{backgroundColor:\"unset\",color:l})};if(r){i.setAttribute(\"selected\",\"true\");var f=function(){i.removeAttribute(\"selected\");n.removeEventListener(\"mousemove\",f)};n.addEventListener(\"mousemove\",f)}return i}function a(p){return __awaiter(this,void 0,void 0,function(){function t(){if(document.body.contains(i)){document.body.removeChild(i)}r.removeEventListener(\"change\",t);r.blur()}var r,n,i,o,a,s,u,l,c,d,f;return __generator(this,function(e){switch(e.label){case 0:r=p.target;n=r.style.display;r.style.display=\"none\";return[4,new Promise(function(e){return setTimeout(e,10)})];case 1:e.sent();r.style.display=n;i=document.createElement(\"vuplex-dropdown-container\");Object.assign(i.style,{position:\"fixed\",top:0,right:0,bottom:0,left:0,zIndex:2147483648});document.body.appendChild(i);i.onclick=t;r.addEventListener(\"change\",t);i.onmousedown=function(e){return e.stopPropagation()};i.onmouseup=function(e){return e.stopPropagation()};o=document.createElement(\"vuplex-dropdown\");a=r.getBoundingClientRect();s=navigator.userAgent.indexOf(\"Firefox\")===-1?0:1;u={left:a.left-s+\"px\",width:a.width+\"px\",top:a.top+a.height+\"px\",position:\"absolute\",backgroundColor:\"white\",display:\"block\",boxShadow:\"0 4px 10px rgba(0, 0, 0, .2)\",border:\"1px solid #bcbcbc\",zIndex:2147483648,maxHeight:h+\"px\",overflow:\"scroll\",textAlign:\"left\"};Object.assign(o.style,u);i.appendChild(o);l=v.default(r.querySelectorAll(\"option\"));c=l.find(function(e){return e.value===r.value});l.forEach(function(e){var t=e===c;var n=g(e,r,o,t);o.appendChild(n);if(t){d=n}});i.addEventListener(\"wheel\",function(e){var t=e.target===o||o.contains(e.target);if(!t){e.preventDefault()}});f=o.getBoundingClientRect().height;if(f>h&&d.offsetTop>h){o.scrollTo(0,d.offsetTop)}return[2]}})})}return{setters:[function(e){v=e}],execute:function(){o=\"vuplex\";h=300;n=function(){function e(){setInterval(this._checkIfSelectElementsWereAddedOrRemoved.bind(this),250)}e.prototype._checkIfSelectElementsWereAddedOrRemoved=function(){var e=document.querySelectorAll(\"select:not([multiple]):not([disabled])\");var t=v.default(e);for(var n=0,r=t;n<r.length;n++){var i=r[n];if(!i.getAttributeNS(o,\"managed\")){i.setAttributeNS(o,\"managed\",\"true\");i.addEventListener(\"click\",a)}}};return e}();e(\"default\",n)}}});_vuplexSystem.register(\"optional/ViewportMetaTagManager\",[],function(e,t){\"use strict\";var n;var r=t&&t.id;return{setters:[],execute:function(){n=function(){function e(e,t){var r=this;if(t===void 0){t=false}this.overrideViewportMetaTag=function(){var e=document.querySelector(\"meta[name=viewport]\");var t=!!e;if(!e){e=document.createElement(\"meta\");e.setAttribute(\"name\",\"viewport\")}var n=r._allowZoom?\"\":\", minimum-scale=1.0, maximum-scale=1.0, user-scalable=0\";e.setAttribute(\"content\",\"viewport-fit=cover, width=device-width, initial-scale=1.0\"+n);if(!t){document.head.appendChild(e)}};this._allowZoom=t;if(e){if(document.readyState===\"loading\"){document.addEventListener(\"DOMContentLoaded\",this.overrideViewportMetaTag)}else{this.overrideViewportMetaTag()}}}return e}();e(\"default\",n)}}});_vuplexSystem.register(\"android/enableInputTypeWorkaround\",[],function(e,t){\"use strict\";var n=t&&t.id;function r(){setInterval(i,200)}e(\"default\",r);function i(){var e=document.activeElement;if(e instanceof HTMLInputElement&&(e.type===\"email\"||e.type===\"number\")){e.type=\"text\"}}return{setters:[],execute:function(){}}});_vuplexSystem.register(\"android/enableAnchorTargetAttributeRemoval\",[],function(e,t){\"use strict\";var n=t&&t.id;function r(){setInterval(i,500)}e(\"default\",r);function i(){var e=document.querySelectorAll(\"a[target=_blank]\");e.forEach(function(e){return e.removeAttribute(\"target\")})}return{setters:[],execute:function(){}}});_vuplexSystem.register(\"optional/FocusManager\",[],function(e,t){\"use strict\";var n;var r=t&&t.id;return{setters:[],execute:function(){n=function(){function e(e){if(e===void 0){e=window}this._activeElementDuringLastBlur=null;this._window=e}e.prototype.setFocused=function(e){if(e){var t=this._activeElementDuringLastBlur||this._document.activeElement;if(t instanceof this._window.HTMLElement){t.focus();this._activeElementDuringLastBlur=null}return}var n=this._document.activeElement;this._activeElementDuringLastBlur=n;if(n instanceof this._window.HTMLElement){n.blur()}};Object.defineProperty(e.prototype,\"_document\",{get:function(){return this._window.document},enumerable:false,configurable:true});return e}();e(\"default\",n)}}});_vuplexSystem.register(\"android/downloadBlobUrl\",[],function(e,t){\"use strict\";var n=t&&t.id;function r(e,t,n){var r={type:\"vuplex.webview.blobUrlDownloadFinished\",url:e,downloadId:n,failed:false,base64Data:\"\"};var i=new XMLHttpRequest;i.open(\"GET\",e,true);i.setRequestHeader(\"Content-type\",t);i.responseType=\"blob\";i.onloadend=function(){if(i.status===200){var n=new FileReader;n.readAsDataURL(i.response);n.onloadend=function(){var e=n.result;var t=e.split(\";base64,\",2)[1];r.base64Data=t;window.vuplex.postMessage(r)}}else{r.failed=true;window.vuplex.postMessage(r)}};i.send()}e(\"default\",r);return{setters:[],execute:function(){}}});_vuplexSystem.register(\"android/index\",[\"android/AndroidBridge\",\"initBrowserAgent\",\"optional/KeyboardInputManager\",\"optional/SelectElementManager\",\"optional/ViewportMetaTagManager\",\"android/enableInputTypeWorkaround\",\"android/enableAnchorTargetAttributeRemoval\",\"optional/FocusManager\",\"android/downloadBlobUrl\"],function(e,t){\"use strict\";var n,r,i,o,a,s,u,l,c;var d=t&&t.id;return{setters:[function(e){n=e},function(e){r=e},function(e){i=e},function(e){o=e},function(e){a=e},function(e){s=e},function(e){u=e},function(e){l=e},function(e){c=e}],execute:function(){window.__initVuplex=function(e){var t=new n.default;r.default(t,{browserAgentOptions:e,optionalComponents:{focusManager:new l.default,keyboardInputManager:new i.default,selectElementManager:(e===null||e===void 0?void 0:e.enableSelectElementManager)?new o.default:undefined,viewportMetaTagManager:new a.default(!!(e===null||e===void 0?void 0:e.overrideViewportMetaTag))}});window._vuplexInternal.downloadBlobUrl=c.default;if(e===null||e===void 0?void 0:e.enableInputTypeWorkaround){s.default()}if(e===null||e===void 0?void 0:e.removeAnchorTargetAttributes){u.default()}}}}});_vuplexSystem.require(\"android/index\");";
        int n2 = 1;
        String string2 = this.h ? "true" : "false";
        objectArray2[n2] = string2;
        n2 = 2;
        string2 = this.o() ? "true" : "false";
        objectArray2[n2] = string2;
        n2 = 3;
        string2 = this.n ? "true" : "false";
        objectArray2[n2] = string2;
        n2 = 4;
        string2 = Q ? "true" : "false";
        objectArray2[n2] = string2;
        n2 = 5;
        string2 = this.n() ? "true" : "false";
        objectArray2[n2] = string2;
        n2 = 6;
        string2 = R ? "true" : "false";
        objectArray2[n2] = string2;
        this.b = String.format(string, objectArray2);
    }

    private /* synthetic */ void a(String baseUrl, String encodedHtml, String html) {
        if (baseUrl == null) {
            this.M.loadData(encodedHtml, "text/html; charset=utf-8", "UTF-8");
        } else {
            this.M.loadDataWithBaseURL(baseUrl, html, "text/html; charset=utf-8", "UTF-8", baseUrl);
        }
    }

    private static /* synthetic */ void k(String userAgent) {
        for (WebView webView : i0) {
            webView.M.getSettings().setUserAgentString(userAgent);
        }
    }

    private /* synthetic */ void a(String javaScript, ValueCallback valueCallback) {
        this.M.evaluateJavascript(javaScript, valueCallback);
    }

    static /* synthetic */ a a(WebView x0, a x1) {
        x0.j = x1;
        return x1;
    }

    static /* synthetic */ boolean b(WebView x0, boolean x1) {
        x0.s = x1;
        return x1;
    }

    static /* synthetic */ String z(WebView x0) {
        return x0.L;
    }

    static /* synthetic */ String f(WebView x0, String x1) {
        x0.L = x1;
        return x1;
    }

    static /* synthetic */ ValueCallback a(WebView x0, ValueCallback x1) {
        x0.u = x1;
        return x1;
    }

    static /* synthetic */ j a(WebView x0, j x1) {
        x0.t = x1;
        return x1;
    }

    static /* synthetic */ boolean a(WebView x0, boolean x1) {
        x0.A = x1;
        return x1;
    }

    static /* synthetic */ boolean t(WebView x0) {
        return x0.s;
    }

    static /* synthetic */ boolean c(WebView x0, String x1) {
        return x0.f(x1);
    }

    static /* synthetic */ boolean s(WebView x0) {
        return x0.b();
    }

    static /* synthetic */ void d(WebView x0, String x1) {
        x0.c(x1);
    }

    static /* synthetic */ j q(WebView x0) {
        return x0.t;
    }

    static /* synthetic */ float a(WebView x0, float x1) {
        x0.G = x1;
        return x1;
    }

    static {
        System.loadLibrary("VuplexWebViewAndroid");
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "v4.8.1-beta";
        objectArray[1] = WebView.d("6342b0fc-0034-4424-a882-13df9bd2c13e");
        Log.i((String)TAG, (String)String.format("Using Vuplex 3D WebView for Android %s %s", objectArray2));
        e0 = com.vuplex.webview.WebView$l.a;
        g0 = new HashMap<String, c>(){
            {
                c c2;
                c c3;
                c c4;
                c c5;
                c c6;
                c c7;
                c c8;
                c c9;
                c c10;
                c c11;
                c c12;
                c c13;
                c c14;
                c c15;
                c c16;
                c c17;
                c c18;
                c c19;
                c c20;
                c c21;
                c c22;
                c c23;
                c c24;
                c c25;
                c c26;
                c c27;
                c c28;
                c c29;
                c c30;
                c c31;
                c c32;
                c c33;
                c c34;
                c c35;
                c c36;
                c c37;
                c c38;
                c c39;
                c c40;
                c c41;
                c c42;
                c c43;
                c c44;
                c c45;
                c c46;
                c c47;
                c c48;
                c c49;
                c c50;
                c c51;
                c c52;
                c c53;
                c c54;
                c c55;
                c c56;
                c c57;
                c c58;
                c c59;
                c c60;
                c c61;
                c c62;
                c c63;
                c c64;
                c c65;
                c c66;
                c c67;
                c c68;
                c c69;
                c c70;
                c c71;
                c c72;
                c c73;
                c c74;
                c c75;
                c c76;
                c c77;
                c c78;
                c c79;
                c c80;
                c c81;
                c c82;
                c c83;
                c c84;
                c c85;
                c c86;
                c c87;
                c c88 = c87;
                c87 = new c("Alt", 18);
                this.put("Alt", c88);
                c88 = c86;
                c86 = new c("Control", 17);
                this.put("Control", c88);
                c88 = c85;
                c85 = new c("CapsLock", 20);
                this.put("CapsLock", c88);
                c88 = c84;
                c84 = new c("Meta", 91);
                this.put("Meta", c88);
                c88 = c83;
                c83 = new c("NumLock", 144);
                this.put("NumLock", c88);
                c88 = c82;
                c82 = new c("ScrollLock", 145);
                this.put("ScrollLock", c88);
                c88 = c81;
                c81 = new c("Enter", 13, "\r");
                this.put("Enter", c88);
                c88 = c80;
                c80 = new c("Tab", 9);
                this.put("Tab", c88);
                c88 = c79;
                c79 = new c("ArrowDown", 40);
                this.put("ArrowDown", c88);
                c88 = c78;
                c78 = new c("ArrowLeft", 37);
                this.put("ArrowLeft", c88);
                c88 = c77;
                c77 = new c("ArrowRight", 39);
                this.put("ArrowRight", c88);
                c88 = c76;
                c76 = new c("ArrowUp", 38);
                this.put("ArrowUp", c88);
                c88 = c75;
                c75 = new c("End", 35);
                this.put("End", c88);
                c88 = c74;
                c74 = new c("Home", 36);
                this.put("Home", c88);
                c88 = c73;
                c73 = new c("PageDown", 34);
                this.put("PageDown", c88);
                c88 = c72;
                c72 = new c("PageUp", 33);
                this.put("PageUp", c88);
                c88 = c71;
                c71 = new c("Backspace", 8);
                this.put("Backspace", c88);
                c88 = c70;
                c70 = new c("Clear", 12);
                this.put("Clear", c88);
                c88 = c69;
                c69 = new c("CrSel", 247);
                this.put("CrSel", c88);
                c88 = c68;
                c68 = new c("Delete", 46);
                this.put("Delete", c88);
                c88 = c67;
                c67 = new c("EraseEof", 249);
                this.put("EraseEof", c88);
                c88 = c66;
                c66 = new c("ExSel", 248);
                this.put("ExSel", c88);
                c88 = c65;
                c65 = new c("Insert", 45);
                this.put("Insert", c88);
                c88 = c64;
                c64 = new c("Accept", 30);
                this.put("Accept", c88);
                c88 = c63;
                c63 = new c("Attn", 240);
                this.put("Attn", c88);
                c88 = c62;
                c62 = new c("Attn", 240);
                this.put("Attn", c88);
                c88 = c61;
                c61 = new c("ContextMenu", 93);
                this.put("ContextMenu", c88);
                c88 = c60;
                c60 = new c("Escape", 27);
                this.put("Escape", c88);
                c88 = c59;
                c59 = new c("Execute", 43);
                this.put("Execute", c88);
                c88 = c58;
                c58 = new c("Finish", 241);
                this.put("Finish", c88);
                c88 = c57;
                c57 = new c("Help", 47);
                this.put("Help", c88);
                c88 = c56;
                c56 = new c("Pause", 19);
                this.put("Pause", c88);
                c88 = c55;
                c55 = new c("Play", 250);
                this.put("Play", c88);
                c88 = c54;
                c54 = new c("Select", 41);
                this.put("Select", c88);
                c88 = c53;
                c53 = new c("PrintScreen", 44);
                this.put("PrintScreen", c88);
                c88 = c52;
                c52 = new c("Standby", 95);
                this.put("Standby", c88);
                c88 = c51;
                c51 = new c("Alphanumeric", 240);
                this.put("Alphanumeric", c88);
                c88 = c50;
                c50 = new c("Convert", 28);
                this.put("Convert", c88);
                c88 = c49;
                c49 = new c("FinalMode", 24);
                this.put("FinalMode", c88);
                c88 = c48;
                c48 = new c("ModeChange", 31);
                this.put("ModeChange", c88);
                c88 = c47;
                c47 = new c("NonConvert", 29);
                this.put("NonConvert", c88);
                c88 = c46;
                c46 = new c("Process", 229);
                this.put("Process", c88);
                c88 = c45;
                c45 = new c("F1", 112);
                this.put("F1", c88);
                c88 = c44;
                c44 = new c("F2", 113);
                this.put("F2", c88);
                c88 = c43;
                c43 = new c("F3", 114);
                this.put("F3", c88);
                c88 = c42;
                c42 = new c("F4", 115);
                this.put("F4", c88);
                c88 = c41;
                c41 = new c("F5", 116);
                this.put("F5", c88);
                c88 = c40;
                c40 = new c("F6", 117);
                this.put("F6", c88);
                c88 = c39;
                c39 = new c("F7", 118);
                this.put("F7", c88);
                c88 = c38;
                c38 = new c("F8", 119);
                this.put("F8", c88);
                c88 = c37;
                c37 = new c("F9", 120);
                this.put("F9", c88);
                c88 = c36;
                c36 = new c("F10", 121);
                this.put("F10", c88);
                c88 = c35;
                c35 = new c("F11", 122);
                this.put("F11", c88);
                c88 = c34;
                c34 = new c("F12", 123);
                this.put("F12", c88);
                c88 = c33;
                c33 = new c("F13", 124);
                this.put("F13", c88);
                c88 = c32;
                c32 = new c("F14", 125);
                this.put("F14", c88);
                c88 = c31;
                c31 = new c("F15", 126);
                this.put("F15", c88);
                c88 = c30;
                c30 = new c("F16", 127);
                this.put("F16", c88);
                c88 = c29;
                c29 = new c("F17", 128);
                this.put("F17", c88);
                c88 = c28;
                c28 = new c("F18", 129);
                this.put("F18", c88);
                c88 = c27;
                c27 = new c("F19", 130);
                this.put("F19", c88);
                c88 = c26;
                c26 = new c("F20", 131);
                this.put("F20", c88);
                c88 = c25;
                c25 = new c("MediaPlayPause", 179);
                this.put("MediaPlayPause", c88);
                c88 = c24;
                c24 = new c("MediaStop", 178);
                this.put("MediaStop", c88);
                c88 = c23;
                c23 = new c("MediaTrackNext", 176);
                this.put("MediaTrackNext", c88);
                c88 = c22;
                c22 = new c("MediaTrackPrevious", 177);
                this.put("MediaTrackPrevious", c88);
                c88 = c21;
                c21 = new c("AudioVolumeDown", 174);
                this.put("AudioVolumeDown", c88);
                c88 = c20;
                c20 = new c("AudioVolumeMute", 173);
                this.put("AudioVolumeMute", c88);
                c88 = c19;
                c19 = new c("AudioVolumeUp", 175);
                this.put("AudioVolumeUp", c88);
                c88 = c18;
                c18 = new c("LaunchMail", 180);
                this.put("LaunchMail", c88);
                c88 = c17;
                c17 = new c("LaunchMediaPlayer", 181);
                this.put("LaunchMediaPlayer", c88);
                c88 = c16;
                c16 = new c("LaunchApplication1", 182);
                this.put("LaunchApplication1", c88);
                c88 = c15;
                c15 = new c("LaunchApplication2", 183);
                this.put("LaunchApplication2", c88);
                c88 = c14;
                c14 = new c("BrowserBack", 166);
                this.put("BrowserBack", c88);
                c88 = c13;
                c13 = new c("BrowserFavorites", 171);
                this.put("BrowserFavorites", c88);
                c88 = c12;
                c12 = new c("BrowserForward", 167);
                this.put("BrowserForward", c88);
                c88 = c11;
                c11 = new c("BrowserHome", 172);
                this.put("BrowserHome", c88);
                c88 = c10;
                c10 = new c("BrowserRefresh", 168);
                this.put("BrowserRefresh", c88);
                c88 = c9;
                c9 = new c("BrowserSearch", 170);
                this.put("BrowserSearch", c88);
                c88 = c8;
                c8 = new c("BrowserStop", 169);
                this.put("BrowserStop", c88);
                c88 = c7;
                c7 = new c("Decimal", 110);
                this.put("Decimal", c88);
                c88 = c6;
                c6 = new c("Multiply", 106);
                this.put("Multiply", c88);
                c88 = c5;
                c5 = new c("Add", 107);
                this.put("Add", c88);
                c88 = c4;
                c4 = new c("Divide", 111);
                this.put("Divide", c88);
                c88 = c3;
                c3 = new c("Subtract", 109);
                this.put("Subtract", c88);
                c88 = c2;
                c2 = new c("Separator", 108);
                this.put("Separator", c88);
            }
        };
        h0 = true;
        i0 = new ArrayList();
    }

    private class n
    extends m {
        private n() {
        }

        /*
         * WARNING - void declaration
         */
        public boolean onRenderProcessGone(android.webkit.WebView view, RenderProcessGoneDetail detail) {
            void type;
            Log.e((String)WebView.TAG, (String)("onRenderProcessGone() was called, which indicates that the browser process was terminated. didCrash: " + detail.didCrash()));
            String string = detail.didCrash() ? "CRASHED" : "KILLED";
            WebView.this.d("HandleTerminated", (String)type);
            return true;
        }
    }

    private class m
    extends WebViewClient {
        private m() {
        }

        private String a(SslError error) {
            switch (error.getPrimaryError()) {
                default: {
                    Log.e((String)WebView.TAG, (String)("Unknown SSL error code: " + error.getPrimaryError()));
                    return "SSL_UNKNOWN";
                }
                case 5: {
                    return "SSL_INVALID";
                }
                case 4: {
                    return "SSL_DATE_INVALID";
                }
                case 3: {
                    return "SSL_UNTRUSTED";
                }
                case 2: {
                    return "SSL_IDMISMATCH";
                }
                case 1: {
                    return "SSL_EXPIRED";
                }
                case 0: 
            }
            return "SSL_NOTYETVALID";
        }

        private boolean a(android.webkit.WebView view, String url, boolean isMainFrame) {
            boolean bl = !url.startsWith("http:") && !url.startsWith("https:") && !url.startsWith("data:") && !url.startsWith("file:") && !url.startsWith("about:");
            boolean isCustomUriScheme = bl;
            if (isCustomUriScheme) {
                if (WebView.this.g) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    Context context = WebView.f();
                    try {
                        context.startActivity(intent);
                        return true;
                    }
                    catch (ActivityNotFoundException activityNotFoundException) {
                        ActivityNotFoundException ex = activityNotFoundException;
                        Log.w((String)WebView.TAG, (String)("No activity not found for URL with custom URI scheme: " + url));
                    }
                }
                WebView.this.b(url);
                WebView.this.c();
                WebView.this.a("net::ERR_UNKNOWN_URL_SCHEME", url);
                return true;
            }
            if (WebView.this.G != 1.0f && WebView.this.H) {
                WebView.this.setInitialScale(1.0f);
            }
            WebView webView = WebView.this;
            if (webView.i) {
                WebView.f(webView, url);
                WebView.this.i = false;
                WebView.this.i();
                return true;
            }
            if (isMainFrame && (url.startsWith("file:") || url.startsWith("jar:") || WebView.this.g(url))) {
                WebView.this.loadUrl(url);
                return true;
            }
            return false;
        }

        public void onPageStarted(android.webkit.WebView view, String url, Bitmap favicon) {
            block9: {
                WebView webView = WebView.this;
                WebView.a(webView, null);
                boolean bl = url.startsWith("about:blank#");
                if (!bl) break block9;
                return;
            }
            WebView webView = WebView.this;
            webView.b(url);
            webView = WebView.this;
            WebView.a(webView, true);
            webView = WebView.this;
            try {
                webView.c();
            }
            catch (Exception exception) {
                Exception e2 = exception;
                Log.e((String)WebView.TAG, (String)"An exception occurred during page start", (Throwable)e2);
            }
        }

        /*
         * Unable to fully structure code
         */
        public void onPageFinished(android.webkit.WebView view, String url) {
            block31: {
                block30: {
                    block29: {
                        var3_3 = WebView.this;
                        var3_4 = WebView.i(var3_3);
                        var4_7 = WebView.this;
                        WebView.a(var4_7, false);
                        var4_7 = WebView.this;
                        var4_8 = WebView.t(var4_7);
                        if (!var4_8) ** GOTO lbl29
                        var4_8 = url.startsWith("about:blank#");
                        if (var4_8) ** GOTO lbl29
                        var4_9 = WebView.this;
                        WebView.b(var4_9, false);
                        var4_9 = WebView.this;
                        var4_9 = var4_9.M;
                        var4_9.clearHistory();
lbl29:
                        // 3 sources

                        var4_10 = WebView.this;
                        var4_11 = WebView.c(var4_10, url);
                        if (!var4_11) break block29;
                        return;
                    }
                    var4_12 = WebView.this;
                    var4_13 = WebView.s(var4_12);
                    if (var4_13) ** GOTO lbl48
                    var4_14 = WebView.this;
                    v0 = var4_14;
                    v1 = v0;
                    var4_14 = WebView.n(v0);
                    WebView.d(v1, (String)var4_14);
lbl48:
                    // 2 sources

                    var4_15 = WebView.this;
                    var4_15 = WebView.q((WebView)var4_15);
                    if (var4_15 == null) break block30;
                    var4_15 = WebView.this;
                    v2 = var4_15;
                    v3 = v2;
                    var4_15 = WebView.q((WebView)v2);
                    var4_15 = var4_15.a;
                    var5_16 = WebView.this;
                    var5_16 = WebView.q((WebView)var5_16);
                    WebView.b((WebView)v3, (String)var4_15, var5_16.b);
                }
                if (pageLoadWasInProgress == false) break block31;
                var4_15 = WebView.this;
                v4 = var4_15;
                var4_15 = "HandleLoadFinished";
                try {
                    WebView.e((WebView)v4, (String)var4_15);
                }
                catch (Exception pageLoadWasInProgress) {
                    e = e;
                    Log.e((String)"3D WebView", (String)"An exception occurred while reading the JavaScript file.", (Throwable)e);
                }
            }
        }

        public void onReceivedClientCertRequest(android.webkit.WebView view, ClientCertRequest request) {
            if (WebView.this.e != null) {
                WebView.this.e.accept(request);
            }
        }

        public void onReceivedError(android.webkit.WebView view, WebResourceRequest request, WebResourceError error) {
            if (!request.isForMainFrame()) {
                return;
            }
            String errorCode = error.getDescription().toString();
            String url = request.getUrl().toString();
            Object[] objectArray = new Object[2];
            Object object = objectArray;
            objectArray[0] = errorCode;
            objectArray[1] = url;
            Log.w((String)WebView.TAG, (String)String.format("Page load failed with error code: %s, url: %s", object));
            object = WebView.this;
            WebView.a((WebView)object, new j((WebView)object, errorCode, url));
        }

        public void onReceivedHttpAuthRequest(android.webkit.WebView view, HttpAuthHandler handler, String host, String realm) {
            if (WebView.this.a != null) {
                WebView.this.a.accept(host, handler);
            }
        }

        public void onReceivedHttpError(android.webkit.WebView view, WebResourceRequest request, WebResourceResponse response) {
            if (!request.isForMainFrame()) {
                return;
            }
            String url = request.getUrl().toString();
            int statusCode = response.getStatusCode();
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = statusCode;
            objectArray[1] = url;
            Log.w((String)WebView.TAG, (String)String.format("Server responded with HTTP error status code: %d, url: %s", objectArray2));
        }

        public void onReceivedSslError(android.webkit.WebView view, SslErrorHandler handler, SslError error) {
            Log.w((String)WebView.TAG, (String)("Received SSL error: " + error));
            if (a0) {
                handler.proceed();
            } else {
                super.onReceivedSslError(view, handler, error);
                String errorCode = this.a(error);
                String url = error.getUrl().toString();
                WebView.this.a(errorCode, url);
            }
        }

        public void onScaleChanged(android.webkit.WebView view, float oldScale, float newScale) {
            WebView.a(WebView.this, newScale);
        }

        public boolean shouldOverrideUrlLoading(android.webkit.WebView view, WebResourceRequest request) {
            String string = request.getUrl().toString();
            boolean bl = request.isForMainFrame();
            return this.a(view, string, bl);
        }

        public boolean shouldOverrideUrlLoading(android.webkit.WebView view, String url) {
            return this.a(view, url, true);
        }
    }

    private class i
    extends g {
        private i() {
        }

        public void onHideCustomView() {
            View view = WebView.this.p;
            if (view == null) {
                return;
            }
            ViewGroup parent = (ViewGroup)view.getParent();
            if (parent != null) {
                parent.removeView(WebView.this.p);
            }
            WebView.this.p = null;
        }

        public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
            WebView.this.p = view;
            ViewGroup viewGroup = WebView.h();
            viewGroup.addView(view, 0);
            if (WebView.this.p()) {
                view.bringToFront();
            } else {
                WebView.this.k();
            }
            view.setFocusable(WebView.this.x);
            view.setFocusableInTouchMode(WebView.this.x);
        }
    }

    private class g
    extends WebChromeClient {
        private g() {
        }

        private Uri[] a(Uri[] contentUris) {
            ArrayList<Uri> fileUris = new ArrayList<Uri>();
            for (Uri contentUri : contentUris) {
                Object object = UnityPlayer.currentActivity;
                object = object.getContentResolver();
                object = object.openInputStream(contentUri);
                Object inputStream22 = object;
                File file = this.a(contentUri);
                File file2 = file;
                this.a((InputStream)inputStream22, file2);
                Uri uri = Uri.fromFile((File)file2);
                try {
                    Uri fileUri = uri;
                    fileUris.add(fileUri);
                }
                catch (IOException inputStream22) {
                    IOException e2 = inputStream22;
                    Log.e((String)WebView.TAG, (String)("IOException while trying to open the file from the file picker: " + e2));
                }
            }
            return fileUris.toArray(new Uri[0]);
        }

        private File a(Uri uri) {
            File file;
            File cacheSubdirectoryAbsolutePath;
            String fileName = "tempfile";
            Cursor cursor = UnityPlayer.currentActivity.getContentResolver().query(uri, null, null, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                int index = cursor.getColumnIndex("_display_name");
                fileName = cursor.getString(index);
                cursor.close();
            }
            if (!(cacheSubdirectoryAbsolutePath = new File(WebView.f().getCacheDir().getAbsolutePath() + "/Vuplex.WebView/FileSelection")).exists()) {
                cacheSubdirectoryAbsolutePath.mkdirs();
            }
            if ((file = new File(cacheSubdirectoryAbsolutePath, fileName)).exists()) {
                file.delete();
            }
            file.createNewFile();
            return file;
        }

        private boolean a(final ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
            Consumer<String[]> consumer;
            if (WebView.this.l == null) {
                return false;
            }
            FileSelectionRequest request = new FileSelectionRequest();
            request.acceptFilters = fileChooserParams.getAcceptTypes();
            boolean bl = fileChooserParams.getMode() == 1;
            request.multipleAllowed = bl;
            Consumer<String[]> consumer2 = consumer;
            consumer = new Consumer<String[]>(this){

                public void a(String[] filePaths) {
                    Uri[] fileUris = new Uri[filePaths.length];
                    for (int i2 = 0; i2 < filePaths.length; ++i2) {
                        Uri uri;
                        fileUris[i2] = uri = Uri.fromFile((File)new File(filePaths[i2]));
                    }
                    filePathCallback.onReceiveValue((Object)fileUris);
                }
            };
            request.continueCallback = consumer2;
            request.cancelCallback = () -> filePathCallback.onReceiveValue(null);
            WebView.this.l.accept(request);
            return true;
        }

        private boolean b(ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
            Activity activity;
            Intent intent;
            if (!WebView.this.v) {
                return false;
            }
            if (WebView.this.u != null) {
                WebView.this.u.onReceiveValue(null);
            }
            WebView.a(WebView.this, filePathCallback);
            Uri cameraOutputFileUri = null;
            if (fileChooserParams.isCaptureEnabled()) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("_display_name", "photo.jpg");
                contentValues.put("mime_type", "image/jpg");
                String string = Environment.DIRECTORY_DCIM;
                contentValues.put("relative_path", string);
                cameraOutputFileUri = WebView.f().getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
                intent = new Intent("android.media.action.IMAGE_CAPTURE");
                intent.addFlags(2);
                intent.putExtra("output", (Parcelable)cameraOutputFileUri);
            } else {
                String[] acceptTypes;
                intent = fileChooserParams.createIntent();
                if (fileChooserParams.getMode() == 1) {
                    intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
                }
                if ((acceptTypes = fileChooserParams.getAcceptTypes()).length > 1) {
                    intent.setType("*/*");
                    intent.putExtra("android.intent.extra.MIME_TYPES", acceptTypes);
                }
            }
            final Uri finalCameraOutputFileUri = cameraOutputFileUri;
            HelperActivity.intentToStart = intent;
            HelperActivity.resultCallback = new BiConsumer<Integer, Intent>(){

                public void a(Integer resultCode, Intent data) {
                    ClipData clipData;
                    if (WebView.this.u == null) {
                        return;
                    }
                    ValueCallback nativeFileDialogCallback = WebView.this.u;
                    WebView.a(WebView.this, null);
                    if (resultCode != -1) {
                        nativeFileDialogCallback.onReceiveValue(null);
                        return;
                    }
                    Uri uri = finalCameraOutputFileUri;
                    if (uri != null) {
                        Uri[] uris = new Uri[]{uri};
                        nativeFileDialogCallback.onReceiveValue((Object)uris);
                        return;
                    }
                    Uri[] contentUris = WebChromeClient.FileChooserParams.parseResult((int)resultCode, (Intent)data);
                    if (contentUris == null && (clipData = data.getClipData()) != null && clipData.getItemCount() > 0) {
                        contentUris = new Uri[clipData.getItemCount()];
                        for (int i2 = 0; i2 < clipData.getItemCount(); ++i2) {
                            Uri uri2;
                            ClipData.Item item = clipData.getItemAt(i2);
                            contentUris[i2] = uri2 = item.getUri();
                        }
                    }
                    Uri[] fileUris = null;
                    if (contentUris == null) {
                        Log.e((String)WebView.TAG, (String)"file selection failed because contentUris is null");
                    } else {
                        fileUris = g.this.a(contentUris);
                    }
                    nativeFileDialogCallback.onReceiveValue((Object)fileUris);
                }
            };
            Intent helperActivityIntent = new Intent(WebView.f(), HelperActivity.class);
            try {
                activity = UnityPlayer.currentActivity;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                ActivityNotFoundException e2 = activityNotFoundException;
                Log.e((String)WebView.TAG, (String)("An unexpected error occurred while launching the file picker activity: " + (Object)((Object)e2)));
                filePathCallback.onReceiveValue(null);
                return false;
            }
            activity.startActivityForResult(helperActivityIntent, 0);
            return true;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void a(InputStream inputStream, File file) {
            FileOutputStream fileOutputStream;
            block12: {
                void directory;
                File file2 = file.getParentFile();
                if (directory == null) break block12;
                directory.mkdirs();
            }
            FileOutputStream fileOutputStream2 = fileOutputStream;
            fileOutputStream2(file);
            FileOutputStream output = fileOutputStream2;
            try {
                int n2;
                int read;
                byte[] byArray;
                byte[] buffer = byArray = new byte[4096];
                while ((read = (n2 = inputStream.read(buffer))) != -1) {
                    ((OutputStream)output).write(buffer, 0, read);
                }
                output.flush();
            }
            catch (Throwable throwable) {
                try {
                    ((OutputStream)output).close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            try {
                ((OutputStream)output).close();
                return;
            }
            finally {
                inputStream.close();
            }
        }

        public Bitmap getDefaultVideoPoster() {
            Bitmap.Config config = Bitmap.Config.ARGB_8888;
            return Bitmap.createBitmap((int)10, (int)10, (Bitmap.Config)config);
        }

        public void onCloseWindow(android.webkit.WebView webview) {
            WebView.this.h("HandleCloseRequested");
        }

        /*
         * WARNING - void declaration
         */
        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            block20: {
                int n2;
                JSONObject json22;
                block21: {
                    void level;
                    JSONObject jSONObject;
                    WebView webView = WebView.this;
                    boolean bl = webView.f;
                    if (!bl) break block20;
                    JSONObject jSONObject2 = jSONObject;
                    jSONObject2();
                    json22 = jSONObject2;
                    String string = "type";
                    Object object = "vuplex.webview.consoleMessageLogged";
                    json22.put(string, object);
                    String string2 = "message";
                    object = consoleMessage.message();
                    json22.put(string2, object);
                    object = WebView.this;
                    Object object2 = object;
                    object = consoleMessage.messageLevel();
                    object = ((WebView)object2).a((ConsoleMessage.MessageLevel)object);
                    json22.put("level", (Object)level);
                    String string3 = consoleMessage.sourceId();
                    String source = string3;
                    n2 = source.length();
                    if (n2 <= 0) break block21;
                    json22.put("source", (Object)source);
                }
                String string = "line";
                n2 = consoleMessage.lineNumber();
                json22.put(string, n2);
                Object object = WebView.this;
                WebView webView = object;
                object = json22.toString();
                try {
                    webView.a((String)object);
                }
                catch (JSONException json22) {
                    void e2;
                    e2 = e2;
                    Log.e((String)WebView.TAG, (String)("An unexpected error occurred while handling onConsoleMessage: " + e2));
                }
            }
            return false;
        }

        public boolean onCreateWindow(android.webkit.WebView view, boolean isDialog, boolean isUserGesture, Message resultMessage) {
            switch (com.vuplex.webview.WebView$f.b[WebView.this.E.ordinal()]) {
                default: {
                    Object[] objectArray = new Object[1];
                    Object[] objectArray2 = objectArray;
                    objectArray[0] = WebView.this.E;
                    Log.e((String)WebView.TAG, (String)String.format("Unexpected popup mode: %s", objectArray2));
                    return false;
                }
                case 2: {
                    WebViewClient webViewClient;
                    final android.webkit.WebView temporaryWebView = new android.webkit.WebView(WebView.f());
                    WebViewClient webViewClient2 = webViewClient;
                    webViewClient = new WebViewClient(){

                        public boolean shouldOverrideUrlLoading(android.webkit.WebView view, String url) {
                            WebView.this.D.accept(url, null);
                            temporaryWebView.destroy();
                            return true;
                        }
                    };
                    temporaryWebView.setWebViewClient(webViewClient2);
                    WebView.WebViewTransport transport = (WebView.WebViewTransport)resultMessage.obj;
                    transport.setWebView(temporaryWebView);
                    resultMessage.sendToTarget();
                    return true;
                }
                case 1: 
            }
            Message href = view.getHandler().obtainMessage();
            view.requestFocusNodeHref(href);
            String url = href.getData().getString("url");
            if (url == null) {
                url = "";
            }
            WebView.this.D.accept(url, resultMessage);
            return true;
        }

        public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
            boolean bl = Z;
            callback.invoke(origin, bl, false);
        }

        public boolean onJsAlert(android.webkit.WebView view, String url, String message, final JsResult result) {
            if (WebView.this.I != null) {
                Consumer<Boolean> consumer;
                Consumer<Boolean> consumer2 = consumer;
                consumer = new Consumer<Boolean>(this){

                    public void a(Boolean unusedParam) {
                        result.confirm();
                    }
                };
                WebView.this.I.accept(message, consumer2);
                return true;
            }
            if (WebView.this.w) {
                WebView webView = WebView.this;
                if (webView.P) {
                    webView.c("alert", "ScriptAlerted");
                } else {
                    return false;
                }
            }
            result.cancel();
            return true;
        }

        public boolean onJsBeforeUnload(android.webkit.WebView view, String url, String message, JsResult result) {
            if (WebView.this.w && !WebView.this.P) {
                return false;
            }
            result.confirm();
            return true;
        }

        public boolean onJsConfirm(android.webkit.WebView view, String url, String message, final JsResult result) {
            if (WebView.this.J != null) {
                Consumer<Boolean> consumer;
                Consumer<Boolean> consumer2 = consumer;
                consumer = new Consumer<Boolean>(this){

                    public void a(Boolean confirm) {
                        if (confirm.booleanValue()) {
                            result.confirm();
                        } else {
                            result.cancel();
                        }
                    }
                };
                WebView.this.J.accept(message, consumer2);
                return true;
            }
            if (WebView.this.w) {
                WebView webView = WebView.this;
                if (webView.P) {
                    webView.c("confirm", "ScriptConfirmRequested");
                } else {
                    return false;
                }
            }
            result.cancel();
            return true;
        }

        public boolean onJsPrompt(android.webkit.WebView view, String url, String message, String defaultValue, JsPromptResult result) {
            if (WebView.this.w && !WebView.this.P) {
                return false;
            }
            result.cancel();
            return true;
        }

        @TargetApi(value=21)
        public void onPermissionRequest(PermissionRequest request) {
            ArrayList<String> allowedResources = new ArrayList<String>();
            for (String resource : request.getResources()) {
                if (resource == "android.webkit.resource.AUDIO_CAPTURE" && b0) {
                    allowedResources.add(resource);
                    continue;
                }
                if (resource == "android.webkit.resource.PROTECTED_MEDIA_ID" && Y) {
                    allowedResources.add(resource);
                    continue;
                }
                if (resource == "android.webkit.resource.VIDEO_CAPTURE" && V) {
                    allowedResources.add(resource);
                    continue;
                }
                if (resource != "android.webkit.resource.MIDI_SYSEX" || !c0) continue;
                allowedResources.add(resource);
            }
            if (allowedResources.size() > 0) {
                request.grant(allowedResources.toArray(new String[0]));
            } else {
                request.deny();
            }
        }

        public void onProgressChanged(android.webkit.WebView view, int progressPercent) {
            if (!WebView.this.A) {
                return;
            }
            double progress = (double)progressPercent / 100.0;
            WebView webView = WebView.this;
            webView.d("HandleLoadProgressUpdate", webView.z.format(progress));
        }

        public boolean onShowFileChooser(android.webkit.WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
            if (this.a(filePathCallback, fileChooserParams)) {
                return true;
            }
            return this.b(filePathCallback, fileChooserParams);
        }
    }

    private class h
    extends android.webkit.WebView {
        public h(WebView webView, Context context) {
            super(context);
        }

        public void a(Canvas canvas) {
            super.onDraw(canvas);
        }
    }

    protected static final class l
    extends Enum<l> {
        public static final /* enum */ l a;
        public static final /* enum */ l b;
        public static final /* enum */ l c;
        private static final /* synthetic */ l[] d;

        public static l[] values() {
            return (l[])d.clone();
        }

        public static l valueOf(String name) {
            return Enum.valueOf(l.class, name);
        }

        static {
            l l2;
            l l3;
            l l4;
            l l5 = l4;
            a = new l();
            l l6 = l3;
            b = new l();
            l l7 = l2;
            c = new l();
            d = new l[]{l5, l6, l7};
        }
    }

    private static final class k
    extends Enum<k> {
        public static final /* enum */ k a;
        public static final /* enum */ k b;
        public static final /* enum */ k c;
        private static final /* synthetic */ k[] d;

        public static k[] values() {
            return (k[])d.clone();
        }

        public static k valueOf(String name) {
            return Enum.valueOf(k.class, name);
        }

        static {
            k k2;
            k k3;
            k k4;
            k k5 = k4;
            a = new k();
            k k6 = k3;
            b = new k();
            k k7 = k2;
            c = new k();
            d = new k[]{k5, k6, k7};
        }
    }

    private class j {
        public final String a;
        public final String b;

        public j(WebView webView, String nativeErrorCode, String url) {
            this.a = nativeErrorCode;
            this.b = url;
        }
    }
}

