/*
 * Decompiled with CFR 0.152.
 */
package com.vuplex.webview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.SurfaceTexture;
import android.hardware.HardwareBuffer;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.ActionMode;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.Surface;
import android.view.View;
import com.vuplex.webview.BiConsumer;
import com.vuplex.webview.Consumer;
import com.vuplex.webview.WebView;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class WebView3D
extends WebView
implements ImageReader.OnImageAvailableListener,
SurfaceTexture.OnFrameAvailableListener {
    private static boolean v0;
    private boolean j0;
    private ReentrantReadWriteLock k0;
    private boolean l0;
    private AtomicInteger m0;
    private Consumer<Canvas> n0;
    private SurfaceTexture o0;
    private Surface p0;
    private AtomicBoolean q0;
    private Surface r0;
    private ReentrantReadWriteLock s0;
    private boolean t0;
    private ImageReader u0;

    public WebView3D(String gameObjectName, int openGLTexture, int width, int height, boolean multiThreadedRenderingEnabled, boolean vulkanEnabled, boolean xrEnabled, BiConsumer<String, Object> popupHandler, Message popupResultMessage) {
        super(gameObjectName, 0, 0, width, height, popupHandler, popupResultMessage);
        ReentrantReadWriteLock reentrantReadWriteLock;
        AtomicBoolean atomicBoolean;
        AtomicInteger atomicInteger;
        ReentrantReadWriteLock reentrantReadWriteLock2;
        Serializable serializable = reentrantReadWriteLock2;
        reentrantReadWriteLock2 = new ReentrantReadWriteLock();
        this.k0 = serializable;
        serializable = atomicInteger;
        atomicInteger = new AtomicInteger(0);
        this.m0 = serializable;
        serializable = atomicBoolean;
        atomicBoolean = new AtomicBoolean(true);
        this.q0 = serializable;
        serializable = reentrantReadWriteLock;
        reentrantReadWriteLock = new ReentrantReadWriteLock();
        this.s0 = serializable;
        this.l0 = multiThreadedRenderingEnabled;
        this.t0 = vulkanEnabled;
        this.P = xrEnabled;
        if (vulkanEnabled) {
            this.c(width, height);
        } else {
            this.a(openGLTexture, width, height);
        }
    }

    public static void setForceDrawEnabled(boolean enabled) {
        if (enabled) {
            Log.i((String)"3D WebView", (String)"Force draw was enabled via AndroidWebView.SetForceDrawEnabled()");
        }
        v0 = enabled;
    }

    private static native long createVulkanImage(Object var0);

    private void a(int openGLTexture, int width, int height) {
        Surface surface;
        SurfaceTexture surfaceTexture;
        SurfaceTexture surfaceTexture2;
        this.o0 = surfaceTexture2 = surfaceTexture;
        new SurfaceTexture(openGLTexture).setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.o0.setDefaultBufferSize(width, height);
        this.s0.writeLock().lock();
        surfaceTexture2 = surface;
        surface = new Surface(this.o0);
        this.r0 = surfaceTexture2;
        this.p0 = surfaceTexture2;
        this.s0.writeLock().unlock();
    }

    private void R() {
        View fullScreenView = this.p;
        if (fullScreenView == null) {
            return;
        }
        WebView.a(() -> {
            ReentrantReadWriteLock surfaceLock = this.s0;
            surfaceLock.readLock().lock();
            Surface surface = this.r0;
            surfaceLock.readLock().unlock();
            if (surface == null) return;
            if (!this.q0.get()) {
                return;
            }
            try {
                Canvas canvas;
                int n2 = Build.VERSION.SDK_INT;
                Canvas canvas2 = canvas = n2 >= 23 ? surface.lockHardwareCanvas() : surface.lockCanvas(null);
                Object object = PorterDuff.Mode.CLEAR;
                canvas2.drawColor(0, (PorterDuff.Mode)object);
                fullScreenView.draw(canvas2);
                object = this.n0;
                if (object != null) {
                    object.accept(canvas2);
                }
                surface.unlockCanvasAndPost(canvas2);
                return;
            }
            catch (Exception canvas2) {
                Exception e2 = canvas2;
                Log.e((String)"3D WebView", (String)"An exception occurred while rendering the fullscreen view.", (Throwable)e2);
            }
        });
    }

    private void c(int width, int height) {
        Surface surface;
        ImageReader imageReader = this.u0;
        if (imageReader != null) {
            imageReader.setOnImageAvailableListener(null, null);
            this.u0.close();
        }
        int maxImages = 1;
        int format = 34;
        this.u0 = Build.VERSION.SDK_INT >= 29 ? ImageReader.newInstance((int)width, (int)height, (int)format, (int)maxImages, (long)256L) : ImageReader.newInstance((int)width, (int)height, (int)format, (int)maxImages);
        Handler handler = new Handler(Looper.getMainLooper());
        this.u0.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)this, handler);
        this.r0 = surface = this.u0.getSurface();
        this.p0 = surface;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void S() {
        if (this.o0 == null) return;
        if (!this.q0.get()) {
            return;
        }
        int numberOfTimesToCallUpdateTexImage = this.m0.getAndSet(0);
        if (numberOfTimesToCallUpdateTexImage <= 0) {
            return;
        }
        SurfaceTexture surfaceTexture = this.o0;
        synchronized (surfaceTexture) {
            for (int i2 = 0; i2 < numberOfTimesToCallUpdateTexImage; ++i2) {
                SurfaceTexture surfaceTexture2 = this.o0;
                surfaceTexture2.updateTexImage();
                continue;
            }
            return;
        }
    }

    static /* synthetic */ ReentrantReadWriteLock c(WebView3D x0) {
        return x0.s0;
    }

    static /* synthetic */ Surface d(WebView3D x0) {
        return x0.r0;
    }

    static /* synthetic */ AtomicBoolean e(WebView3D x0) {
        return x0.q0;
    }

    static /* synthetic */ Consumer f(WebView3D x0) {
        return x0.n0;
    }

    static /* synthetic */ boolean a(WebView3D x0, boolean x1) {
        x0.j0 = x1;
        return x1;
    }

    /*
     * WARNING - void declaration
     */
    public void onFrameAvailable(SurfaceTexture st) {
        block5: {
            AtomicInteger atomicInteger = this.m0;
            atomicInteger.incrementAndGet();
            boolean bl = this.l0;
            if (bl) break block5;
            try {
                this.S();
            }
            catch (Exception exception) {
                void e2;
                e2 = e2;
                Log.e((String)"3D WebView", (String)"An unexpected exception occurred in onFrameAvailable", (Throwable)e2);
            }
        }
    }

    public void onImageAvailable(ImageReader reader) {
        Image image = reader.acquireNextImage();
        if (image == null) {
            return;
        }
        HardwareBuffer hardwareBuffer = image.getHardwareBuffer();
        long vulkanImage = WebView3D.createVulkanImage(hardwareBuffer);
        image.close();
        hardwareBuffer.close();
        String string = Long.toUnsignedString(vulkanImage);
        this.d("HandleTextureChanged", string);
    }

    public void render() {
        android.webkit.WebView webView;
        if (v0 && this.q0.get() && (webView = this.M) != null) {
            ((a)webView).a();
        }
        this.R();
        if ((this.l0 || this.p != null) && !this.t0) {
            this.S();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void resize(int width, int height) {
        if (this.t0) {
            this.c(width, height);
        } else {
            SurfaceTexture surfaceTexture = this.o0;
            synchronized (surfaceTexture) {
                SurfaceTexture surfaceTexture2 = this.o0;
                surfaceTexture2.setDefaultBufferSize(width, height);
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
        }
        super.resize(width, height);
    }

    public void setOnAfterDrawCallback(Consumer<Canvas> callback) {
        this.n0 = callback;
    }

    @Override
    public void setRenderingEnabled(boolean enabled) {
        android.webkit.WebView webView;
        this.q0.set(enabled);
        if (enabled && (webView = this.M) != null) {
            ((a)webView).a();
        }
    }

    @Override
    public void setScrollbarsEnabled(boolean enabled) {
    }

    public void setSurface(Surface surface) {
        this.s0.writeLock().lock();
        if (surface == null) {
            Log.i((String)"3D WebView", (String)"The application called AndroidWebView.SetSurface(null) to revert to the original surface.");
            this.r0 = this.p0;
        } else {
            Log.i((String)"3D WebView", (String)"The application called AndroidWebView.SetSurface() to set a custom surface.");
            this.r0 = surface;
        }
        this.s0.writeLock().unlock();
    }

    @Override
    public void setVisible(boolean visible) {
    }

    @Override
    protected android.webkit.WebView a() {
        a webView = new a(WebView.f());
        webView.setInitialScale(100);
        webView.setScrollBarSize(0);
        webView.setVerticalScrollBarEnabled(false);
        webView.setHorizontalScrollBarEnabled(false);
        webView.setFilterTouchesWhenObscured(true);
        webView.setHapticFeedbackEnabled(false);
        if (Build.VERSION.SDK_INT >= 26) {
            webView.setImportantForAutofill(8);
        }
        return webView;
    }

    @Override
    protected void a(Canvas canvas) {
        ((a)this.M).a(canvas);
    }

    @Override
    protected boolean m() {
        boolean bl = WebView.e0 != WebView.l.c;
        return bl;
    }

    @Override
    protected boolean n() {
        return true;
    }

    @Override
    protected boolean o() {
        return true;
    }

    @Override
    protected boolean p() {
        return false;
    }

    private class a
    extends android.webkit.WebView {
        public a(Context context) {
            super(context);
        }

        public void a(Canvas canvas) {
            super.onDraw(canvas);
        }

        public void a() {
            WebView3D.this.k0.readLock().lock();
            boolean forceDrawInProgress = WebView3D.this.j0;
            WebView3D.this.k0.readLock().unlock();
            if (forceDrawInProgress) {
                return;
            }
            WebView.a(() -> {
                WebView3D.this.k0.writeLock().lock();
                WebView3D.a(WebView3D.this, true);
                WebView3D.this.k0.writeLock().unlock();
                try {
                    this.onDraw(null);
                }
                catch (Exception exception) {}
                WebView3D.this.k0.writeLock().lock();
                WebView3D.a(WebView3D.this, false);
                WebView3D.this.k0.writeLock().unlock();
            });
        }

        /*
         * Unable to fully structure code
         */
        protected void onDraw(Canvas unusedCanvas) {
            block15: {
                block14: {
                    surfaceLock = WebView3D.c(WebView3D.this);
                    if (surfaceLock == null) {
                        return;
                    }
                    surfaceLock.readLock().lock();
                    surface = WebView3D.d(WebView3D.this);
                    surfaceLock.readLock().unlock();
                    if (surface == null || !WebView3D.e(WebView3D.this).get()) break block15;
                    try {
                        var4_4 = Build.VERSION.SDK_INT;
                        if (var4_4 < 23) ** GOTO lbl15
                    }
                    catch (Exception v0) {}
                    v1 = surface.lockHardwareCanvas();
                    break block14;
lbl15:
                    // 1 sources

                    v1 = surface.lockCanvas(null);
                }
                canvas = var4_5 = v1;
                var5_6 = PorterDuff.Mode.CLEAR;
                canvas.drawColor(0, var5_6);
                var5_7 = this.getScrollX();
                v2 = -var5_7;
                var5_7 = this.getScrollY();
                var5_8 = -var5_7;
                canvas.translate(v2, var5_8);
                super.onDraw(canvas);
                var5_9 = WebView3D.this;
                var5_9 = WebView3D.f((WebView3D)var5_9);
                if (var5_9 == null) ** GOTO lbl47
                var5_10 = this.getScrollX();
                v3 = var5_10;
                var5_10 = this.getScrollY();
                var5_11 = var5_10;
                canvas.translate(v3, var5_11);
                var5_12 = WebView3D.this;
                var5_12 = WebView3D.f((WebView3D)var5_12);
                var5_12.accept(canvas);
lbl47:
                // 2 sources

                surface.unlockCanvasAndPost(canvas);
                return;
            }
        }

        public boolean onFilterTouchEventForSecurity(MotionEvent event) {
            if (event.getPointerId(0) == 1776) {
                return super.onFilterTouchEventForSecurity(event);
            }
            return false;
        }

        public boolean onHoverEvent(MotionEvent event) {
            if (event.getPointerId(0) == 1776) {
                return super.onHoverEvent(event);
            }
            return false;
        }

        public boolean onTouchEvent(MotionEvent event) {
            if (event.getPointerId(0) == 1776) {
                return super.onTouchEvent(event);
            }
            return false;
        }

        public boolean onGenericMotionEvent(MotionEvent event) {
            if (event.getPointerId(0) == 1776) {
                return super.onGenericMotionEvent(event);
            }
            return false;
        }

        public PointerIcon onResolvePointerIcon(MotionEvent event, int pointerIndex) {
            return null;
        }

        public ActionMode startActionMode(ActionMode.Callback callback) {
            return null;
        }

        public ActionMode startActionMode(ActionMode.Callback callback, int type) {
            return null;
        }
    }
}

