/*
 * Decompiled with CFR 0.152.
 */
package com.dmbfm.magneticdeclination;

import android.app.Activity;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.dmbfm.magneticdeclination.LowPassFilter;

public class NativeHeading
implements SensorEventListener {
    private final Activity mActivity;
    private SensorManager mSensorManager;
    private float[] mGData = new float[3];
    private float[] mMData = new float[3];
    private float[] mR = new float[16];
    private float[] mROut = new float[16];
    private float[] mI = new float[16];
    private float[] mOrientation = new float[3];
    private float mCurrentHeading;
    private float mAlpha = 0.1f;

    public NativeHeading(Activity unityActivity, float alpha) {
        this.mAlpha = alpha;
        this.mActivity = unityActivity;
        this.mSensorManager = (SensorManager)this.mActivity.getSystemService("sensor");
        this.mSensorManager.registerListener((SensorEventListener)this, this.mSensorManager.getDefaultSensor(1), 1);
        this.mSensorManager.registerListener((SensorEventListener)this, this.mSensorManager.getDefaultSensor(2), 1);
    }

    public void onSensorChanged(SensorEvent event) {
        float[] data;
        int type = event.sensor.getType();
        if (type == 2) {
            data = this.mMData;
        } else if (type == 1) {
            data = this.mGData;
        } else {
            return;
        }
        LowPassFilter.filter(event.values, data, this.mAlpha);
        SensorManager.getRotationMatrix((float[])this.mR, (float[])this.mI, (float[])this.mGData, (float[])this.mMData);
        SensorManager.remapCoordinateSystem((float[])this.mR, (int)1, (int)3, (float[])this.mROut);
        SensorManager.getOrientation((float[])this.mROut, (float[])this.mOrientation);
        float rad2deg = 57.29578f;
        this.mCurrentHeading = 57.29578f * this.mOrientation[0];
        if (this.mCurrentHeading < 0.0f) {
            this.mCurrentHeading += 360.0f;
        }
    }

    public float GetCurrentHeading() {
        return this.mCurrentHeading;
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }
}

