using UnityEditor;
using UnityEngine;

namespace XenseAR
{
    [CustomEditor(typeof(AnchoringDetails))]
    [CanEditMultipleObjects]
    public class AnchoringDetailsGUI : Editor
    {
        public override void OnInspectorGUI()
        {
            DrawButtons();
        }

        private void DrawButtons()
        {
            if (targets.Length > 1)
            {
                DrawButtonMultipleTarget();
            }
            else
            {
                DrawButtonSingleTarget();
            }
        }

        private void DrawButtonMultipleTarget()
        {
            if (GUILayout.Button("Refresh"))
            {
                foreach (var obj in targets)
                {
                    if (obj is AnchoringDetails anchoringDetails)
                        anchoringDetails.Refresh();
                }
            }
        }

        private void DrawButtonSingleTarget()
        {
            AnchoringDetails myScript = (AnchoringDetails)target;

            if (GUILayout.Button("Refresh"))
                myScript.Refresh();
        }
    }
}
