using UnityEditor;
using static EditorDefines.Priority.Navigation;
namespace XenseAR
{

    public class SaveLoadMenu
    {
        [MenuItem("ARWorld/Load All %l", false, 0)]

        private static void LoadAll()
        {
            Container.Resolve<AnchoringManager>()?.LoadBlockData();
            Container.Resolve<NavigationTargetManager>()?.LoadBlockData();
            Container.Resolve<NavigationMeshManager>()?.LoadBlockData();
        }

        [MenuItem("ARWorld/Navigation/Load Navigation Mesh", false, Load_Navigation_Mesh)]
        //[Tooltip("This will remove any unsave data you make to the Navigation Targets")]

        private static void LoadNavigationMesh()
        {
            Container.Resolve<NavigationMeshManager>()?.LoadBlockData();
        }

        [MenuItem("ARWorld/Navigation/Load All Navigation Target", false, Load_All_Navigation_Target)]
        //[Tooltip("This will remove any unsave data you make to the Navigation Targets")]

        private static void LoadNavigationTarget()
        {
            Container.Resolve<NavigationTargetManager>()?.LoadBlockData();
        }

        [MenuItem("ARWorld/Navigation/Save All Navigation Target", false, Save_All_Navigation_Target)]

        private static void SaveAllNavigationTarget()
        {
            Container.Resolve<NavigationTargetManager>()?.SaveAllNavigationTarget();
        }
    }
}
