using UnityEditor;
using UnityEngine;
namespace XenseAR {

[CustomEditor(typeof(WorldSelector))]

public class WorldSelectorGUI : Editor
{
    public override void OnInspectorGUI()
    {
        DrawDefaultInspector();

        WorldSelector myScript = (WorldSelector)target;
        if (GUILayout.Button("Load World Data"))
        {
            myScript?.LoadWorldData();
        }
        if (GUILayout.Button("Load Whole Block Data"))
        {
            myScript?.LoadWholeBlockData();
        }
        if(GUILayout.Button("Clear All Child"))
        {
            myScript?.ClearAllChild();
        }
    }

}
}
