namespace XenseAR {

using UnityEngine;

public class AnchoringTrigger : ITrigger
{
    float triggerRadius;
    GameObject ARCamera;

    bool bOntriggerEnter = false;
    bool bOntriggerExit = true;

    public AnchoringTrigger(AnchoringTarget target)
    {
        ARCamera = Camera.main.gameObject;
        this.triggerRadius = target.triggerRadius;
    }

    public bool IsOnTriggerEnter(Transform transform)
    {
        if (bOntriggerEnter) return false;
        float distance = Vector3.Distance(ARCamera.transform.position, transform.position);
        if (distance < triggerRadius)
        {
            bOntriggerEnter = true;
            bOntriggerExit = false;
            return true;
        }
        return false;
    }

    public bool IsOnTriggerExit(Transform transform)
    {
        if (bOntriggerExit) return false;
        float distance = Vector3.Distance(ARCamera.transform.position, transform.position);
        if (distance > triggerRadius)
        {
            bOntriggerExit = true;
            bOntriggerEnter = false;
            return true;
        }
        return false;
    }
}}
