using UnityEngine;
namespace XenseAR {


public class DistanceHeightAlgorithm : ILoadingTargetAlgorithm
{
    const float INTERESTEDDISTANCE = 18;
    const float DISPOSE_DISTANCE = 30;
    const float HEIGHT = 3;
    GameObject ARCamera;
    private float interestedDistance = INTERESTEDDISTANCE; //Lets user modify this value base on their experience, default value is 18 time
    private float disPoseDistance = DISPOSE_DISTANCE;
    public DistanceHeightAlgorithm(float interestedDistance = INTERESTEDDISTANCE, float disPoseDistance = DISPOSE_DISTANCE)
    {
        ARCamera = Camera.main.gameObject;
        this.interestedDistance = interestedDistance;
        this.disPoseDistance = disPoseDistance;
    }

    public bool IsNeedLoad(AnchoringTarget target, Transform transform)
    {
        //get distance from camera to the root point of target
        float distance = Vector3.Distance(ARCamera.transform.position, transform.position);

        if(ARCamera.transform.position.y+HEIGHT< transform.position.y)
            return false;
        if (ARCamera.transform.position.y  > transform.position.y)
            return false;

        if (distance <= interestedDistance * Mathf.Max(target.boundSize.x, target.boundSize.y, target.boundSize.z))
        {
            return true;
        }
        //if the distance is greater than the interested distance then should not show the target
        return false;
    }
    public bool IsNeedDispose(AnchoringTarget target, Transform transform)
    {
        float distance = Vector3.Distance(ARCamera.transform.position, transform.position);

        if (distance >= disPoseDistance * Mathf.Max(target.boundSize.x, target.boundSize.y, target.boundSize.z))
        {
            return true;
        }
        if (ARCamera.transform.position.y > transform.position.y)
            return true;
        return false;
    }
}}
