using System;
using Unity.Behavior;
using UnityEngine;
using Action = Unity.Behavior.Action;
using Unity.Properties;

[Serializable, GeneratePropertyBag]
[NodeDescription(name: "Assign distance between two transform to a float", story: "Assignment [Value] with distance between [Value1] and [Value2]", category: "Action/Blackboard", id: "07aa8315db0648e18cc768f379c9adfc")]
public partial class DistanceValueAssignAction : Action
{
    [SerializeReference] public BlackboardVariable<float> Value;
    [SerializeReference] public BlackboardVariable<Transform> Value1;
    [SerializeReference] public BlackboardVariable<Transform> Value2;

    protected override Status OnStart()
    {
        if (Value == null || Value1 == null || Value2 == null)
            return Status.Failure;

        Value.Value = Vector3.Distance(Value1.Value.position, Value2.Value.position);
        return Status.Running;
    }
}

