using System;
using Unity.Behavior;
using UnityEngine;
using Action = Unity.Behavior.Action;
using Unity.Properties;
using BehaviorTree;

[Serializable, GeneratePropertyBag]
[NodeDescription(name: "Value Assignment (float)", story: "Assignment [Value] with [Value1] [Operation] [Value2]", category: "Action/Blackboard", id: "1fdf2bb3b6b0b7845df1067620118b02")]
public partial class FloatValueAssignmentAction: Action
{
    [SerializeReference] public BlackboardVariable<float> Value;
    [SerializeReference] public BlackboardVariable<float> Value1;
    [SerializeReference] public BlackboardVariable<Operator> Operation;
    [SerializeReference] public BlackboardVariable<float> Value2;

    protected override Status OnStart()
    {
        if (Value == null || Value1 == null || Value2 == null)
            return Status.Failure;

        return Status.Running;
    }

    protected override Status OnUpdate()
    {
        switch (Operation.Value)
        {
            case Operator.Add:
                Value.Value = Value1.Value + Value2.Value;
                break;
            case Operator.Minus:
                Value.Value = Value1.Value - Value2.Value;
                break;
            case Operator.Mul:
                Value.Value = Value1.Value * Value2.Value;
                break;
            case Operator.Div:
                Value.Value = Value1.Value / Value2.Value;
                break;
            case Operator.Mod:
                Value.Value = Value1.Value % Value2.Value;
                break;
            default:
                break;
        }
        return Status.Success;
    }

    protected override void OnEnd()
    {
    }
}

