using System;
using Unity.Behavior;
using UnityEngine;

[Serializable, Unity.Properties.GeneratePropertyBag]
[Condition(name: "Get Object Active State", story: "Get [Object] Active State", category: "Conditions", id: "99c183e34370ac929a794aee4e827ef5")]
public partial class GetObjectActiveStateCondition : Condition
{
    [SerializeReference] public BlackboardVariable<GameObject> Object;

    public override bool IsTrue()
    {
        if (Object.Value == null) return false;
        return Object.Value.activeSelf;
    }

    public override void OnStart()
    {
    }

    public override void OnEnd()
    {
    }
}
