using System.Collections;
using System.Collections.Generic;
using System.Threading.Tasks;
using System.Threading;
using UnityEngine;
namespace XenseAR {

public class AsyncExtension<G>
{
    public static async Task<G> FreeMainWhileAwait(Task<G> task, CancellationToken token = default)
    {
#if UNITY_ANDROID || UNITY_IOS || UNITY_STANDALONE
        var result = task;
        while (!task.GetAwaiter().IsCompleted)
        {
            if (token.IsCancellationRequested)
            {
                token.ThrowIfCancellationRequested();
            }
            await Task.Delay(Defines.milisecondCheckCancel, token);

        }
        return result.GetAwaiter().GetResult();
#else
        var result = await task;
        return result;
#endif
    }
}
}
