using System;
using System.Collections.Generic;
using UnityEngine;
namespace XenseAR {

public class DataResources 
{
    public Dictionary<string, Sprite> Images = new Dictionary<string, Sprite>();

    public Dictionary<string, AudioClip> Clips = new Dictionary<string, AudioClip>();

    public Dictionary<string, GameObject> Models= new Dictionary<string, GameObject>();

    public Dictionary<string, mTransform> ChildOriginTransforms = new Dictionary<string, mTransform>();

    public List<Dictionary<string, GameObject>> ListGroupObjects = new List<Dictionary<string, GameObject>>();
    public Dictionary<string, Dictionary<string, List<Color>>> ChildOriginColor = new Dictionary<string, Dictionary<string, List<Color>>>();

    public Dictionary<string, Dictionary<string, List<Tuple<Material, GLTFast.Schema.Material, Texture2D>>>> ChildOriginMaterial = new Dictionary<string, Dictionary<string, List<Tuple<Material, GLTFast.Schema.Material, Texture2D>>>>();

    public Dictionary<GameObject, List<GLTFTextureRecoverInfo>> GLTFTextures = new Dictionary<GameObject, List<GLTFTextureRecoverInfo>>();
    public Dictionary<GameObject, List<GLTFMeshRecoverInfo>> GLTFMeshs = new Dictionary<GameObject, List<GLTFMeshRecoverInfo>>();
}

[Serializable]
public class GLTFTextures
{
    public Texture2D[] texture2Ds;
}

[Serializable]
public class GLTFMeshs
{
    public Mesh[] meshes;
}

public struct GLTFTextureRecoverInfo
{
    public enum GLTFShaderType
    {
        PbrMetallicRoughness,
        PbrSpecularGlossiness,
        Unlit
    }
    public GLTFShaderType shaderType;
    public Material material;
    public List<Tuple<string, int>> textureInfos;
}

public struct GLTFMeshRecoverInfo
{
    public enum MeshFilterType
    {
        MeshFilter,
        SkinnedMeshRenderer
    }

    public MeshFilterType filterType;
    public SkinnedMeshRenderer skinnedMeshRenderer;
    public MeshFilter meshFilter;
    public int meshIndex;
}
}
