using System.Collections;
using System.Collections.Generic;
using UnityEngine;
namespace XenseAR {

public class MapPointer : MonoSingleton<MapPointer>
{
    // Start is called before the first frame update
    [SerializeField] GameObject model;
    void Start()
    {
        GameObject resource = Resources.Load<GameObject>(Defines.PrefabResourceURL.MapPointerPrefab);
        model = Instantiate<GameObject>(resource, transform);
    }
    bool bRayCastEnable = false;
    public void SetEnable(bool ison)
    {
        bRayCastEnable = ison;
        if (ison)
        {
            
        }
        else
        {

        }
    }
    RaycastHit hit;
    Ray ray;
    private void Update()
    {
        if (bRayCastEnable)
        {
            ray = Camera.main.ScreenPointToRay(Input.mousePosition);
            if (Physics.Raycast(ray, out hit))
            {
                if (hit.transform.gameObject != null)
                {
                    transform.position = hit.point;
                }
            }
            else
            {
                Ray ray360 = ray;
                ray360.origin = ray360.GetPoint(100f);
                ray360.direction = -ray360.direction;
                if (Physics.Raycast(ray360, out hit, 100f))
                {
                    if (hit.transform.gameObject != null)
                    {
                        transform.position = hit.point;
                    }
                }
            }
        }
        else
        {
            //model.SetActive(false);
        }
    }
}
}
