using System;
using System.Collections.Generic;
using TMPro;
using UnityEngine;
using UnityEngine.UI;
namespace XenseAR {

public enum MinoPosition
{
    Top,
    Center,
    Bottom
}

public class Mino : MonoBehaviour
{
    public GameObject avatar;

    public TextMeshProUGUI textBubble;

    private static Mino _instance;

    private void Awake()
    {
        _instance = this;
        DontDestroyOnLoad(this);
    }

    public static Mino instance
    {
        get
        {
            if (_instance != null)
            {
                GameObject canvas = GameObject.FindGameObjectWithTag("MainCanvas");
                _instance.transform.SetParent(canvas.transform);
                _instance.transform.localScale = Vector3.one;
                _instance.transform.localPosition = Vector3.zero;
                return _instance;
            }
            else
            {
                GameObject resource = Resources.Load<GameObject>(Defines.PrefabResourceURL.MinoPrefab);
                GameObject gameObject = Instantiate<GameObject>(resource, GameObject.FindGameObjectWithTag("MainCanvas").transform);
                gameObject.transform.localPosition = Vector3.zero;
                _instance = gameObject.GetComponent<Mino>();
                return _instance;
            }

        }
    }

    private void GoOnTop()
    {
        int totalUI = _instance.gameObject.transform.parent.childCount;
        _instance.gameObject.transform.SetSiblingIndex(totalUI - 1);
    }

    public void Show(MinoPosition position = MinoPosition.Bottom, string text = "", float delayHide = 0f)
    {
        gameObject.SetActive(true);
        SetPosition(position);
        textBubble.text = text;
        GoOnTop();
        UpdateLayout();

        if (delayHide > 0f)
        {
            Invoke(nameof(Hide), delayHide);
        }
    }

    public void Hide()
    {
        gameObject.SetActive(false);
    }

    private void UpdateLayout()
    {
        foreach (var layout in GetComponentsInChildren<LayoutGroup>())
        {
            LayoutRebuilder.ForceRebuildLayoutImmediate(layout.GetComponent<RectTransform>());
        }
    }

    private void SetPosition(MinoPosition position)
    {
        RectTransform rectTransform = avatar.GetComponent<RectTransform>();
        switch (position)
        {
            case MinoPosition.Top:
                rectTransform.anchorMax = Vector2.up;
                rectTransform.anchorMin = Vector2.up;
                rectTransform.pivot = Vector2.up;
                rectTransform.anchoredPosition = new Vector2(28f, -107f);
                break;
            case MinoPosition.Center:
                rectTransform.anchorMax = Vector2.up / 2f;
                rectTransform.anchorMin = Vector2.up / 2f;
                rectTransform.pivot = Vector2.up / 2f;
                rectTransform.anchoredPosition = new Vector2(28f, 0f);
                break;
            case MinoPosition.Bottom:
                rectTransform.anchorMax = Vector2.zero;
                rectTransform.anchorMin = Vector2.zero;
                rectTransform.pivot = Vector2.zero;
                rectTransform.anchoredPosition = new Vector2(28f, 88f);
                break;
        }
    }
}
}
