using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using TMPro;
namespace XenseAR {

public class Notifier : MonoBehaviour
{
    private static Notifier _instance;

    [SerializeField] Image icon;
    [SerializeField] TextMeshProUGUI message;
    [SerializeField] CanvasGroup canvasGroup;
    [SerializeField] Color defaultColor = new Color32(88, 206, 159, 255);

    public Sprite defaultIcon;

    private void Awake()
    {
        _instance = this;
    }

    public static Notifier instance
    {
        get
        {
            if (_instance != null)
            {
                return _instance;
            }
            else
            {
                GameObject resource = Resources.Load<GameObject>(Defines.PrefabResourceURL.NotifyPrefab);
                GameObject gameObject = Instantiate<GameObject>(resource, GameObject.FindGameObjectWithTag("MainCanvas").transform);
                gameObject.transform.localPosition = Vector3.zero;
                _instance = gameObject.GetComponent<Notifier>();
                return _instance;
            }
        }
    }
    private void FixedUpdate()
    {
        
    }
    public void Show(string message, Sprite icon = null)
    {
        Show(message, defaultColor, icon);
    }

    public void Show(string message, Color textColor, Sprite icon = null)
    {
        this.message.text = message;
        canvasGroup.alpha = 1;

        this.message.color = textColor;

        if (icon != null)
        {
            this.icon.gameObject.SetActive(true);
            if (icon) this.icon.sprite = icon;
            else this.icon.sprite = defaultIcon;
        }
        else
        {
            this.icon.gameObject.SetActive(false);
        }
        Invoke("Hide", 3);
    }

    private void Hide()
    {
        canvasGroup.alpha = 0;
    }
}
}
