using System;
using UnityEngine;
using UnityEngine.SceneManagement;
namespace XenseAR {

public class SceneLoader : MonoBehaviour
{
    public void LoadScene(string sceneName)
    {
        EventManager.Instance.PostNotification(EVENT_TYPE.StartUnloadScene, this);
        var operation = SceneManager.UnloadSceneAsync(SceneManager.GetActiveScene().name
            ,UnloadSceneOptions.UnloadAllEmbeddedSceneObjects);
        operation.completed += (asyncOperation) =>
        {
            Resources.UnloadUnusedAssets();
            SceneManager.LoadScene(sceneName, LoadSceneMode.Additive);
            EventManager.Instance.PostNotification(EVENT_TYPE.FinishUnloadScene, this);
        };
    }
}
}
