using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Splines;
namespace XenseAR {

public class TimeSynchronization : MonoSingleton<TimeSynchronization>
{
    public bool SplineAnimateSynchronize(GameObject go)
    {
        var currentDate = System.DateTime.Now;
        int daySeconds = (currentDate.Hour * 3600) + (currentDate.Minute * 60) + (currentDate.Second);

        SplineAnimate splineAnimate = go.GetComponentInChildren<SplineAnimate>();
        if (splineAnimate == null) return false;
        splineAnimate.StartOffset = (daySeconds % splineAnimate.Duration)/ splineAnimate.Duration;

        return true;
    }
}
}
