using System;
using System.Collections.Generic;
using UnityEngine;
namespace XenseAR {

[CreateAssetMenu(fileName = "ARWorldSetting", menuName = "ScriptableObjects/ARWorldSetting", order = 1)]
public class AppSettingObject : ScriptableObject
{
    public string InferenceServer;
    public string ExperienceScene;
    public LocationSettings LocationSetting;
    public string WorldId;
    public List<string> LocationInfoGroups;
    public XenseConfigURL XenseUrl;
    public bool applyDynamicOcclusion = false;
}
[Serializable]
public class LocationSettings
{
    public string name;
    public GPS gps;
    public string blockId;
    public string appId;
    public string vpsService;
    public float modelScale=-1;
    public string inferenceServer;
}

[Serializable]
public class GPS
{
    public float x;
    public float y;
}

[Serializable]
public class XenseConfigURL
{
    public string backendURL;
    public string homeURL;
    public string sessionURL;
    public string analysisURL;
    public string authenticationUid;

    public void Update(XenseConfigURL other)
    {
        this.backendURL = other.backendURL;
        this.homeURL = other.homeURL;
        this.sessionURL = other.sessionURL;
        this.analysisURL = other.analysisURL;
        this.authenticationUid = other.authenticationUid;
    }
}}
