using System.Collections.Generic;
using System.Linq;
namespace XenseAR {
    using System.Net.Http.Headers;
    using Proyecto26;

using UnityEngine;

public class MandatoryDataLoader : MonoBehaviour
{
    [SerializeField] DataScriptableObject sessionData;

    public void Load(string blockID)
    {
        LoadAnchoring(blockID);
        LoadNavigationMesh(blockID);
    }

    public void LoadAnchoring(string blockID)
    {
        BackendServices.Instance.Post(new RequestHelper
        {
            SimpleForm = new Dictionary<string, string>()
            {
                {"type","GetBlockAnchoringTargetsData" },
                {"BlockID",blockID },
            },
            //            Uri = "",
        }).Then(res => OnFinishLoadBlockAnchoringData(res, blockID));

    }

    private async void OnFinishLoadBlockAnchoringData(ResponseHelper res, string blockID)
    {
        var webresp = JsonUtility.FromJson<Defines.BlockAnchoringResponse>(res.Text);
        sessionData.SessionData.anchoring = webresp.data;
        sessionData.SessionData.anchoring.blockId = blockID;

        var mandatoryAnchor = sessionData.SessionData.anchoring.targets.Where(x => x.MandatoryData == true).ToList();

        foreach (var target in mandatoryAnchor)
        {
            AssetBundleLoader loader = new AssetBundleLoader(this, target.media.url, target.media.name);
            if(State.Instance.downloadingAnchor.ContainsKey(target.media.url))
            {
                continue;
                
            }
                var loadingTask = loader.LoadAsync(null, false);
                State.Instance.downloadingAnchor.Add(target.media.url, loadingTask);
                await loadingTask;
                if (State.Instance.downloadingAnchor.ContainsKey(target.media.url))
                {
                    State.Instance.downloadingAnchor.Remove(target.media.url);
                }
           //await loader.LoadAsync(null, false);
        }
    }

    public void LoadNavigationMesh(string blockID)
    {
        bool ret = false;
        string data = "";
        BackendServices.Instance.Post(new RequestHelper
        {
            SimpleForm = new Dictionary<string, string>()
            {
                {"type", "GetBlockNavigationMeshData" },
                {"blockID", blockID },
            },
            //            Uri = "",
        }).Then(res =>
        {
            data = res.Text;
            OnLoadNavigationMesh(data, blockID);
            ret = true;
        }).Catch(ex => { ret = true; });
    }
    protected void OnLoadNavigationMesh(string data, string blockID)
    {
        var webresp = JsonUtility.FromJson<BlockNavigationMeshResponse>(data);
        if (webresp.status != Defines.successCode) return;
        if (sessionData.SessionData.navigation == null) sessionData.SessionData.navigation = new Navigation();
        sessionData.SessionData.navigation.meshs = webresp.data;

        foreach (var mesh in sessionData.SessionData.navigation.meshs)
        {
            AssetBundleLoader loader = new AssetBundleLoader(this, mesh.url, mesh.name);
            loader.LoadAsync(null, false);
        }
    }
}}
