using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using UnityEngine;
namespace XenseAR {

public class WorldSelector : MonoBehaviour
{
    public string worldId;
    public List<WorldData> worldDatas;
    DataLoader loader;
    private string blockID;
    private Dictionary<string, GameObject> groupWrapperGameObjects = new Dictionary<string, GameObject>();
    DataScriptableObject sessionDataObject;

    public async Task<bool> LoadWorldData()
    {
        sessionDataObject.SessionData.anchoring.blockId = string.Empty;
        sessionDataObject.SessionData.anchoring.worldId = string.Empty;
        await Task.Delay(100);
        if (string.IsNullOrEmpty(worldId) || worldDatas.Where(x => x.worldId.Equals(worldId)).Count() == 0) {
            worldId = "Please paste a valid world id from the list below!";
            return false;
        }
        bool ret = false;
        ret = await loader.LoadAnchoringFromEdu(blockID, worldId);
        return ret;
    }

    public async Task<bool> LoadGroupData(string groupId)
    {
        sessionDataObject.SessionData.anchoring.blockId = string.Empty;
        sessionDataObject.SessionData.anchoring.worldId = string.Empty;
        await Task.Delay(100);
        if (string.IsNullOrEmpty(worldId) || worldDatas.Where(x => x.worldId.Equals(worldId)).Count() == 0) {
            worldId = "Please paste a valid world id from the list below!";
            return false;
        }
        bool ret = false;
        ret = await loader.LoadAnchoringFromEdu(blockID, worldId, groupId);
        return ret;
    }

    public async Task<bool> LoadWholeBlockData()
    {
        sessionDataObject.SessionData.anchoring.blockId = string.Empty;
        sessionDataObject.SessionData.anchoring.worldId = string.Empty;
        await Task.Delay(100);
        bool ret = false;
        ret = await loader.LoadAnchoringFromEdu(blockID);
        return ret;
    }

    public void ClearAllChild()
    {
        List<GameObject> childBlocks = new List<GameObject>();
        int childCount = transform.childCount;
        for (int i = 0; i < childCount; i++)
        {
            childBlocks.Add(transform.GetChild(i).gameObject);
        }

        foreach (GameObject childBlock in childBlocks)
        {
            Destroy(childBlock);
        }

        LabelManager.Instance.RemoveAll();
    }

    internal void Init(DataLoader loader, List<WorldData> worldDatas, string blockId, DataScriptableObject sessionDataObject)
    {
        this.sessionDataObject = sessionDataObject;
        this.loader = loader;
        this.worldDatas = worldDatas;
        this.blockID = blockId;
    }
}
}
