using System;
using System.Collections;
using System.Collections.Generic;
using Cysharp.Threading.Tasks;
using UnityEngine;
namespace XenseAR {

public class Bullet : PoolingObject
{
    public Rigidbody m_Rb;
    public float bulletSpeed;

    public virtual void Setup(float _bulletSpeed)
    {
        bulletSpeed = _bulletSpeed;
        m_Rb.linearVelocity = transform.forward * bulletSpeed;
    }

    private void OnCollisionEnter(Collision other)
    {
        AssetbundleAnchor assetbundleAnchor = other.gameObject.GetComponentInParent<AssetbundleAnchor>();
        if (assetbundleAnchor != null)
        {
            PrefabManager.Instance.SpawnVFXPool("VFX", transform.position);
            string message = assetbundleAnchor.Id;
            API.Game_OnHit(message);
        }
        DespawnPool();
    }
}
}
