using System.Collections;
using System.Collections.Generic;
using UnityEngine;
namespace XenseAR {

public abstract class PoolingObject : MonoBehaviour
{
    public float m_LifeTimeMax;
    public float m_LifeTime;

    public virtual void OnEnable()
    {
        m_LifeTime = m_LifeTimeMax;
    }

    public virtual void Update()
    {
        m_LifeTime -= Time.deltaTime;

        if (m_LifeTime < 0)
        {
            PrefabManager.Instance.DespawnPool(gameObject);
        }
    }

    public virtual void DespawnPool()
    {
        PrefabManager.Instance.DespawnPool(gameObject);
    }
}
}
