using System.Collections;
using System.Collections.Generic;
using UnityEngine;
namespace XenseAR {

public class TestGameManager : MonoSingleton<TestGameManager>
{
    public PrefabManager prefabManager;

    protected override void Awake()
    {
        DontDestroyOnLoad(this);
        base.Awake();
    }

    private void Update()
    {
        if (Input.GetKeyDown(KeyCode.D))
        {
            string urlObjectPooling = "https://s3.educationxr.vn/ar-world/AssetBundles/GameBundles/GameObjectPooling/prefabmanager_shootinggame1";
            AssetBundleLoader assetBundleLoader = new AssetBundleLoader(this, urlObjectPooling, "Assets/Scripts/Game/PrefabManager.prefab");
            assetBundleLoader.LoadAsync();
        }
        if (Input.GetKeyDown(KeyCode.C))
        {
            Bullet bullet = PrefabManager.Instance.SpawnBulletPool("Bullet", Camera.main.transform.position + Camera.main.transform.forward * 1, Camera.main.transform.rotation).GetComponent<Bullet>();
            bullet.Setup(5);
        }
        if (Input.GetKeyDown(KeyCode.Space))
        {
            Bullet bullet = PrefabManager.Instance.SpawnBulletPool("Bullet", Camera.main.transform.position + Camera.main.transform.forward * 1, Camera.main.transform.rotation).GetComponent<Bullet>();
            bullet.Setup(5);
        }
    }
}
}
