using System;
using UnityEngine.Events;

namespace XenseAR
{

    public interface IAnchoringLabel
    {
        public void Load(AnchoringTarget target);

        public void UpdateData(AnchoringTarget target);

        public void UnLoad();

        public void Dispose();

        public string GetBlockID();

        public void SetBlockID(string blockId);

        public AnchoringMediaType GetType();

        public string Id { get; }
        public UnityEngine.GameObject LabelObject { get; }

        public event Action<IAnchoringLabel> OnLoadAnchor;
        public event Action<IAnchoringLabel> OnDisposeAnchor;

    }
}
