using System;
using System.Collections.Generic;
namespace XenseAR
{

    public class LabelManager : MonoSingleton<LabelManager>
    {
        List<IAnchoringLabel> anchoringLabels = new List<IAnchoringLabel>();

        public event Action<(LabelChangeEvent labelEvent, IAnchoringLabel label)> LabelChange;

        public enum LabelChangeEvent
        {
            Add,
            Remove
        }

        protected override void Awake()
        {
            anchoringLabels = new List<IAnchoringLabel>();
            base.Awake();
        }
        protected void Start()
        {

        }

        public bool Add(IAnchoringLabel label)
        {
            if (anchoringLabels.Contains(label)) return false;
            anchoringLabels.Add(label);
            LabelChange?.Invoke((LabelChangeEvent.Add, label));
            return true;
        }

        public bool Remove(IAnchoringLabel label)
        {
            if (anchoringLabels.Contains(label))
            {
                anchoringLabels.Remove(label);
                LabelChange?.Invoke((LabelChangeEvent.Remove, label));
                return true;
            }
            return false;
        }

        public bool RemoveAll()
        {
            anchoringLabels.Clear();
            return true;
        }

        public IAnchoringLabel FindById(string labelId)
        {
            foreach (var label in anchoringLabels)
            {
                if (label.Id == labelId) return label;
            }
            return null;
        }
        public List<IAnchoringLabel> Labels => anchoringLabels;
    }
}
