using System;
using System.Linq;
namespace XenseAR {

using UnityEditor;

using UnityEngine;
using UnityEngine.SceneManagement;

[InitializeOnLoad]
public class CustomNavigationHierarchy : MonoBehaviour
{
    static CustomNavigationHierarchy()
    {
        EditorApplication.hierarchyWindowItemOnGUI += HandleHierarchyWindowItemOnGUI;
    }

    private static void HandleHierarchyWindowItemOnGUI(int instanceID, Rect selectionRect)
    {
        var obj = EditorUtility.InstanceIDToObject(instanceID);
        if (obj != null && (obj is GameObject))
        {
            NavigationTargetEditor navigationTargetEditor = (obj as GameObject).GetComponent<NavigationTargetEditor>();
            if (navigationTargetEditor != null)
            {
                #region Content data
                //Draw position
                Rect iconRect = new Rect(selectionRect.position, Vector2.one * selectionRect.size.y);
                Rect objNameRect = new Rect(
                    selectionRect.position + new Vector2(iconRect.width + 2, 0),
                    selectionRect.size - new Vector2(iconRect.width + 2, 0)
                );

                //Icon
                //GUIContent icon = new GUIContent(EditorGUIUtility.GetIconForObject(obj));
                //if (icon.image == null)
                //{
                //    //Get default icon from unity base icon
                //    icon = EditorGUIUtility.IconContent("d_GameObject Icon");
                //}
                #endregion

                #region Color and text default value
                //Color32 backgroundColor = new Color32(56, 56, 56, 255);
                //Color32 iconColor = new Color32(255, 255, 255, 255);
                Color32 objNameColor = new Color32(205, 205, 205, 0);
                #endregion

                #region Color and text custom value
                Color32 Label_New = new Color32(100, 150, 100, 255);
                Color32 Label_Edited = new Color32(100, 100, 150, 255);
                Color32 Label_Verified = new Color32(100, 150, 100, 255);
                Color32 Label_Error = new Color32(150, 100, 100, 255);
                Color32 Label_Delete = new Color32(100, 100, 100, 255);
                #endregion

                #region Draw hierarchy layout
                GUILayout.BeginArea(objNameRect);
                GUILayout.BeginHorizontal();
                GUILayout.Label(obj.name, new GUIStyle()
                {
                    normal = new GUIStyleState() { textColor = objNameColor },
                });
                if (navigationTargetEditor.isNew)
                {
                    if (navigationTargetEditor.isDeleted)
                    {
                        GUILayout.Label("Restoring...", new GUIStyle()
                        {
                            stretchWidth = false,
                            padding = new RectOffset(5, 5, 0, 0),
                            margin = new RectOffset(10, 10, 0, 0),
                            normal = new GUIStyleState() { textColor = Color.white, background = Utility.CreateTexture2D(Label_New) },
                        });
                    }
                    else
                    {
                        GUILayout.Label("New", new GUIStyle()
                        {
                            stretchWidth = false,
                            padding = new RectOffset(5, 5, 0, 0),
                            margin = new RectOffset(10, 10, 0, 0),
                            normal = new GUIStyleState() { textColor = Color.white, background = Utility.CreateTexture2D(Label_New) },
                        });
                    }
                }
                if (navigationTargetEditor.isEdited)
                {
                    GUILayout.Label("Edited", new GUIStyle()
                    {
                        stretchWidth = false,
                        padding = new RectOffset(5, 5, 0, 0),
                        margin = new RectOffset(10, 10, 0, 0),
                        normal = new GUIStyleState() { textColor = Color.white, background = Utility.CreateTexture2D(Label_Edited) },
                    });
                }
                //if (navigationTargetEditor.isVerified)
                //{
                //    GUILayout.Label("Verified", new GUIStyle()
                //    {
                //        stretchWidth = false,
                //        padding = new RectOffset(5, 5, 0, 0),
                //        margin = new RectOffset(10, 10, 0, 0),
                //        normal = new GUIStyleState() { textColor = Color.white, background = Utility.CreateTexture2D(Label_Verified) },
                //    });
                //}
                if (navigationTargetEditor.isError)
                {
                    GUILayout.Label("Error", new GUIStyle()
                    {
                        stretchWidth = false,
                        padding = new RectOffset(5, 5, 0, 0),
                        margin = new RectOffset(10, 10, 0, 0),
                        normal = new GUIStyleState() { textColor = Color.white, background = Utility.CreateTexture2D(Label_Error) },
                    });
                }
                if (navigationTargetEditor.isDeleted)
                {
                    GUILayout.Label("Deleted", new GUIStyle()
                    {
                        stretchWidth = false,
                        padding = new RectOffset(5, 5, 0, 0),
                        margin = new RectOffset(10, 10, 0, 0),
                        normal = new GUIStyleState() { textColor = Color.white, background = Utility.CreateTexture2D(Label_Delete) },
                    });
                }
                GUILayout.EndHorizontal();
                GUILayout.EndArea();
                #endregion
            }
        }
        EditorApplication.RepaintHierarchyWindow();
    }
}}
