mergeInto(LibraryManager.library, {

	UnityMessageHandlerReady: function() {
		if (window.UnityMessageHandlerReady)
		{
			window.UnityMessageHandlerReady();
		}
	},

	UnityRequestCameraFeed: function () {
		if (window.UnityRequestCameraFeed)
		{
			window.UnityRequestCameraFeed();
		}
	},

	UnityModelPlaced: function () {
		if (window.UnityModelPlaced)
		{
			window.UnityModelPlaced();
		}
	},

	SendMessageToWeb: function (message) {
		if (window.SendMessageToWeb)
		{
			if(UTF8ToString(message).includes("|")) {
				window.SendMessageToWeb(UTF8ToString(message));
			}else {
				window.OnReceivedUnityMessage(UTF8ToString(message));
			}
		}
	},

	DownloadFile : function(array, size, fileNamePtr)
	{
		var fileName = UTF8ToString(fileNamePtr);

		var bytes = new Uint8Array(size);
		for (var i = 0; i < size; i++)
		{
			bytes[i] = HEAPU8[array + i];
		}

		var blob = new Blob([bytes]);
		var link = document.createElement('a');
		link.href = window.URL.createObjectURL(blob);
		link.download = fileName;

		var event = document.createEvent("MouseEvents");
		event.initMouseEvent("click");
		link.dispatchEvent(event);
		window.URL.revokeObjectURL(link.href);
	},

});