using UnityEngine;

namespace XenseAR
{
    public class MegaEditorManager : MonoBehaviour
    {
        [SerializeField] GameObject NavigationUI;

        private void Start()
        {
            NavigationSystemManager.NavigationStatusChange += NavigationStatusChange;
        }

        private void OnDestroy()
        {
            NavigationSystemManager.NavigationStatusChange -= NavigationStatusChange;
        }

        private void NavigationStatusChange((NavigationEvent state, Vector3? destination) data)
        {
            switch (data.state)
            {
                case NavigationEvent.StartNavigate:
                    NavigationUI.SetActive(true);
                    break;
                case NavigationEvent.DestinationChange:
                    break;
                case NavigationEvent.StopNavigate:
                    NavigationUI.SetActive(false);
                    break;
                case NavigationEvent.PauseNavigate:
                    //NavigationUI.SetActive(false);
                    break;
                case NavigationEvent.ResumeNavigate:
                    NavigationUI.SetActive(true);
                    break;
                case NavigationEvent.DestinationArrived:
                    break;
                default:
                    break;
            }
        }
    }
}
