using System;
using System.Collections.Generic;

using UnityEngine;
#if USE_VUPLEX_WEBVIEW
using Vuplex.WebView;
#endif
namespace XenseAR
{
    public class NativeAPI
    {
#if UNITY_IOS && !UNITY_EDITOR
    [System.Runtime.InteropServices.DllImport("__Internal")]
    public static extern void sendMessageToMobileApp(string message);
#endif
    }

    public static class API
    {
        static List<string> pendingMessages = new List<string>();
        static bool initialized = false;
        public static string androidType = "native";
#if USE_VUPLEX_WEBVIEW
        static CanvasWebViewPrefab canvasWebView;
        public static void Init(CanvasWebViewPrefab webView)
        {
            Clear();
            canvasWebView = webView;
            foreach (var message in pendingMessages)
            {
                Send(message);
            }
            pendingMessages.Clear();
            initialized = true;
        }

        public static void Clear()
        {
            canvasWebView = null;
            initialized = false;
        }
#endif

#if UNITY_WEBGL
        public static void InitWebGLSender()
        {
        initialized = true;
        }
#endif
        static private void SendMessageToMobileApp(string message)
        {
            if (Application.platform == RuntimePlatform.Android)
            {
                try
                {
                    string androidJavaClass = "com.unity3d.player.CommunicationActivity";
                    if (androidType.Equals("reactNative"))
                    {
                        androidJavaClass = "com.azesmwayreactnativeunity.ReactNativeUnityViewManager";
                    }

                    using (AndroidJavaClass jc = new AndroidJavaClass(androidJavaClass))
                    {
                        jc.CallStatic("sendMessageToMobileApp", message);
                    }
                }
                catch (Exception ex)
                {
                }
            }
            else if (Application.platform == RuntimePlatform.IPhonePlayer)
            {
#if UNITY_IOS && !UNITY_EDITOR
            NativeAPI.sendMessageToMobileApp(message);
#endif
            }
        }

        static void UpdatePendingMessage(string message)
        {
            if (initialized) return;
            pendingMessages.Add(message);
        }

        static private void Send(string message)
        {
#if UNITY_WEBGL && !UNITY_EDITOR
            JavascriptCall.SendMessageToWeb(message);
#elif UNITY_WEBGL && UNITY_EDITOR
#else
#if USE_VUPLEX_WEBVIEW
            canvasWebView.WebView.PostMessage(message);
#endif
#endif
            SendMessageToMobileApp(message);
        }

        public static void SendAPIMessage(string apiName, string apiMessage)
        {
            string message = "{\"type\": \"" + apiName + "\", \"message\": \"" + apiMessage + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }
        public static void NativeGalleryPermissionGranted(bool isGranted)
        {
            string message = "{\"type\": \"nativeGalleryPermissionGranted\", \"message\": \"" + isGranted.ToString() + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }
        public static void LocationPermissionGranted(bool isGranted)
        {
            string message = "{\"type\": \"locationPermissionGranted\", \"message\": \"" + isGranted.ToString() + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }
        public static void UpdateDeviceID(string deviceId)
        {
            string message = "{\"type\": \"deviceId\", \"message\": \"" + deviceId + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }
        public static void UpdateBlockId(string blockId)
        {
            string message = "{\"type\": \"updateBlockId\", \"message\": \"" + blockId + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }

        public static void PointerClick(string objectId)
        {
            string message = "{\"type\": \"pointerClick\", \"message\": \"" + objectId + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }
        public static void CaptureFinish(bool success)
        {
            string message = "{\"type\": \"captureFinish\", \"message\": \"" + success.ToString() + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }

        public static void ChangeCheckinFrameDone(bool success)
        {
            string message = "{\"type\": \"changeCheckinFrameDone\", \"message\": \"" + success.ToString() + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }

        public static void NavigateComplete(string target)
        {
            string message = "{\"type\": \"navigationComplete\", \"message\": \"" + target + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }

        public static void UpdateNavigate(string target)
        {
            string message = "{\"type\": \"updateNavigate\", \"message\": \"" + target + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }

        public static void NavigateEnd(string target)
        {
            string message = "{\"type\": \"navigationEnd\", \"message\": \"" + target + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }

        public static void StartNavigate(string target)
        {
            string message = "{\"type\": \"startNavigate\", \"message\": \"" + target + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }
        public static void StartCapture()
        {
            string message = "{\"type\": \"startCapture\",  \"message\": \"" + "" + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }
        public static void StartGameAR(string gameId)
        {
            string message = "{\"type\": \"startGameAR\", \"message\": \"" + gameId + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }
        public static void OnTriggerEnter(string objectId)
        {
            string message = "{\"type\": \"onTriggerEnter\", \"message\": \"" + objectId + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }
        public static void OnTriggerExit(string objectId)
        {
            string message = "{\"type\": \"onTriggerExit\", \"message\": \"" + objectId + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }
        public static void ReturnStateMessage(string stateMessage)
        {
            string message = "{\"type\": \"returnStateMessage\", \"message\": \"" + stateMessage + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }
        public static void OnGPSUpdate(string stateMessage)
        {
            string message = "{\"type\": \"onGPSUpdate\", \"message\": " + stateMessage + "}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }

        public static void UpdateLocationGroup(string stateMessage)
        {
            string message = "{\"type\": \"locationGroupUpdate\", \"message\": \"" + stateMessage + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }

        public static void UpdateAnchoringDownloadProgress(string stateMessage)
        {
            string message = "{\"type\": \"updateAnchoringDownloadProgress\", \"message\": \"" + stateMessage + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }

        public static void GetPlayerPresString(string stateMessage)
        {
            string message = "{\"type\": \"playerPresString\", \"message\": \"" + stateMessage + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }

        public static void BackToHomeScreen(string stateMessage)
        {
            string message = "{\"type\": \"backToHomeScreen\", \"message\": \"" + stateMessage + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }

        public static void Game_OnHit(string stateMessage)
        {
            string message = "{\"type\": \"gameOnHit\", \"message\": \"" + stateMessage + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }

        public static void GameCountDownEnd(string stateMessage)
        {
            string message = "{\"type\": \"gameCountDownEnd\", \"message\": \"" + stateMessage + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }

        public static void GameCheckCoolDown(string stateMessage)
        {
            string message = "{\"type\": \"gameCheckCoolDown\", \"message\": \"" + stateMessage + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }

        public static void CameraRequest(bool stateMessage)
        {
            string message = "{\"type\": \"cameraPermission\", \"message\": \"" + stateMessage.ToString() + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }
        public static void CloseRecordMode(bool stateMessage)
        {
            string message = "{\"type\": \"closeRecordVideoMode\", \"message\": \"" + stateMessage.ToString() + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }

        public static void OpenWebView(bool stateMessage)
        {
            string message = "{\"type\": \"openWebView\", \"message\": \"" + stateMessage.ToString() + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }

        public static void RequestUIForWorldSpace(string stateMessage)
        {
            string message = "{\"type\": \"requestUIForWorldSpace\", \"message\": \"" + stateMessage + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }

        public static void TransitMessage(string stateMessage)
        {
            string message = "{\"type\": \"transitMessage\", \"message\": \"" + stateMessage + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }

        public static void GetUid(string stateMessage)
        {
            string message = "{\"type\": \"getUid\", \"message\": \"" + stateMessage + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }

        public static void UpdateCurrentVersion(string stateMessage)
        {
            string message = "{\"type\": \"updateCurrentVersion\", \"message\": \"" + stateMessage + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }

        public static void CancelPermissionPopup(string stateMessage)
        {
            string message = "{\"type\": \"cancelPermissionPopup\", \"message\": \"" + stateMessage + "\"}";
            if (initialized) Send(message);
            UpdatePendingMessage(message);
        }
    }
}
