using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Android;
namespace XenseAR {

public class CameraRequest : MonoBehaviour
{
    private void Awake()
    {
        Container.Register(this);
    }

    IEnumerator RequestCameraPermission()
    {
#if UNITY_IOS && !UNITY_EDITOR
        // Check if the camera permission is already granted
        if (!Application.HasUserAuthorization(UserAuthorization.WebCam))
        {
            // Request the camera permission (this will trigger the native permission dialog)
            yield return Application.RequestUserAuthorization(UserAuthorization.WebCam);
        }

        // Check if the user granted permission
        if (Application.HasUserAuthorization(UserAuthorization.WebCam))
        {
            // Permission granted, you can use the camera
            Debug.Log("Camera permission granted.");
            API.CameraRequest(true);
        }
        else
        {
            // Permission denied
            Debug.Log("Camera permission denied.");
            API.CameraRequest(false);
        }
#endif



//hien tai k co option chon open camera cho android
//#if UNITY_ANDROID && !UNITY_EDITOR
//        if (Permission.HasUserAuthorizedPermission(Permission.Camera))
//        {
//            Debug.Log("Camera permission granted.");
//            API.CameraRequest(true);
//        }
//        else
//        {
//            //bool useCallbacks = false;
//            //if (!useCallbacks)
//            //{
//            //    // Ask for permission or proceed without the functionality enabled.
//            //    Permission.RequestUserPermission(Permission.Camera);
//            //}
//            //else
//            //{
//                var callbacks = new PermissionCallbacks();
//                callbacks.PermissionDenied += PermissionCallbacks_PermissionDenied;
//                callbacks.PermissionGranted += PermissionCallbacks_PermissionGranted;
//                callbacks.PermissionDeniedAndDontAskAgain += PermissionCallbacks_PermissionDeniedAndDontAskAgain;
//                Permission.RequestUserPermission(Permission.Camera, callbacks);
//            //}
//        }
//#endif
        yield break;
    }

    public void StartCameraRequest()
    {
        StartCoroutine(RequestCameraPermission());
    }

    internal void PermissionCallbacks_PermissionDeniedAndDontAskAgain(string permissionName)
    {
        Debug.Log($"{permissionName} PermissionDeniedAndDontAskAgain");
        Debug.Log("Camera permission granted.");
        API.CameraRequest(false);
    }

    internal void PermissionCallbacks_PermissionGranted(string permissionName)
    {
        Debug.Log($"{permissionName} PermissionCallbacks_PermissionGranted");
        Debug.Log("Camera permission granted.");
        API.CameraRequest(true);
    }

    internal void PermissionCallbacks_PermissionDenied(string permissionName)
    {
        Debug.Log($"{permissionName} PermissionCallbacks_PermissionDenied");
        Debug.Log("Camera permission granted.");
        API.CameraRequest(false);
    }
}
}
