namespace XenseAR
{
    using System;
    using System.Collections.Generic;

    using UnityEngine;

    public class Defines
    {
        public static class PlayerPrefsKey
        {
            public const string Skip = "Skip";
        }

        public enum SceneMode
        {
            Edit,
            View
        }

        public static class SceneName
        {
            public const string Home = "StartScene";
        }

        public static class Theme
        {
            public static Color32 ThemeColor = new Color32(252, 179, 22, 255);
            public static Color32 ThemeNormalTextColor = new Color32(252, 179, 22, 255);
            public static Color32 ThemeBoldTextColor = new Color32(13, 12, 84, 255);
        }

        public static class LabelBackgroundColor
        {
            public static Color32 NewColor = new Color32(100, 150, 100, 255);
            public static Color32 EditedColor = new Color32(128, 108, 77, 255);
            public static Color32 SavedColor = new Color32(100, 100, 150, 255);
            public static Color32 ErrorColor = new Color32(150, 100, 100, 255);
        }

        public enum PermisisonName
        {
            Camera,
            Location,
            Notification,
            Gallery,
            Microphone
        }

        public static class LocalizationKey
        {
            public const string locationAllow = "locationAllow";
            public const string locationAllowAndroid = "locationAllowAndroid";
            public const string locationAllowIOS = "locationAllowIOS";

            public const string cameraAllow = "cameraAllow";
            public const string cameraAllowAndroid = "cameraAllowAndroid";
            public const string cameraAllowIOS = "cameraAllowIOS";

            public const string galleryAllow = "galleryAllow";
            public const string galleryAllowAndroid = "galleryAllowAndroid";
            public const string galleryAllowIOS = "galleryAllowIOS";

            public const string microphoneAllow = "microphoneAllow";
            public const string microphoneAllowAndroid = "microphoneAllowAndroid";
            public const string microphoneAllowIOS = "microphoneAllowIOS";

            public const string DetectPlane = "DetectPlane";
            public const string TabToShow = "TabToShow";
            public const string imageSave = "imageSave";
            public const string proceed = "proceed";
            public const string exitEscalator = "exitEscalator";
            public const string movingCamera = "movingCamera";
            public const string localizing = "localizing";
            public const string localizeSuccess = "localizeSuccess";
            public const string destinationArrived = "destinationArrived";
            public const string escalatorSafetyWarning = "escalatorSafetyWarning";
            public const string noNavigationDataFound = "noNavigationDataFound";
            public const string stopNavigationConfirmation = "stopNavigationConfirmation";
            public const string retryScanLocation = "retryScanLocation";
            public const string arAppScanFailed = "arAppScanFailed";

            public const string scanningGuide = "scanningGuide";


            public const string ExitComfirm = "ExitComfirm";
            public const string DestinationArrived = "DestinationArrived";

            public const string tryAgain = "tryAgain";
            public const string confirm = "confirm";
            public const string continue1 = "continue1";
            public const string back = "back";
            public const string cancel = "cancel";
            public const string yes = "yes";
            public const string no = "no";
            public const string ignore = "ignore";
            public const string collect = "collect";
            public const string distanceRemain = "distanceRemain";
            public const string Floor = "Floor";
            public const string captureSave = "captureSave";
            public const string photoAllow = "photoAllow";
            public const string videoAllow = "videoAllow";
            public const string arNotSupport = "arNotSupport";

            public const string setting = "setting";
        }

        public static class PermisisonText
        {
            public const string locationAllow = "Bật tuỳ chọn cài đặt vị trí trong “Xense AR” để sử dụng ứng dụng";
            public const string cameraAllow = "Bật tuỳ chọn cài đặt máy ảnh trong “Xense AR” để sử dụng ứng dụng";
            public const string locationAllowAndroid = "1. Chọn \"Quyền\"\n2. Chọn \"Vị trí\"\n3. Chọn \"Cho phép\" và \"Sử dụng vị trí chính xác\"";
            public const string cameraAllowAndroid = "1. Chọn \"Quyền\"\n2. Chọn \"Máy ảnh\"\n3. Chọn \"Cho phép\"";
            public const string locationAllowIOS = "1. Chọn <b>Vị trí</b>\n2. Nhấn vào <b>Luôn luôn</b> hoặc <b>Khi mở ứng dụng</b>";
            public const string cameraAllowIOS = "Trong cài đặt XENSE AR, nhấn bật Camera";
        }

        public static class InstructionText
        {
            public const string DetectPlane = "Hướng camera vào mặt phẳng \r\ncố định để đặt mô hình.";
            public const string TabToShow = "Ấn để hiện mô hình";
            public const string imageSave = "Đã lưu";
            public const string proceed = "Tiếp tục";
            public const string exitEscalator = "Đã rời khỏi thang";
            public const string movingCamera = "Đứng tại vị trí và hướng camera vào các khu vực dễ nhận biết";
            public const string localizing = "Hệ thống đang xác định vị trí của bạn";
            public const string localizeSuccess = "Thành công xác định vị trí của bạn";
            public const string destinationArrived = "Xin chúc mừng!\nBạn đã tới nơi";
            public const string escalatorSafetyWarning = "Vì an toàn tạm dừng nhìn điện thoại\nẤn tiếp tục khi rời thang";
            public const string noNavigationDataFound = "Chưa có dữ liệu điều hướng, vui lòng thử lại!";
            public const string stopNavigationConfirmation = "Bạn muốn kết thúc điều hướng?";
            public const string retryScanLocation = "Scan vị trí thất bại.\nVui lòng thử lại";
            public const string arAppScanFailed = "Scan không thành công. Đảm bảo bạn có mặt tại\nvị trí để trải nghiệm ứng dụng nhé!";

            public const string scanningGuide = "Hướng dẫn scan vị trí";
        }

        public static class MinoText
        {
            public const string ExitComfirm = "Xác nhận khi bạn đã rời\nkhỏi thang nhé!";
            public const string DestinationArrived = "Yeah! Bạn đã tới\n";

        }

        public static class InstructionDynamicContent
        {
            public const string ScanLocationBasic = "InstructionDynamicContent/ScanLocationBasic";
            public const string ScanLocationContent = "InstructionDynamicContent/ScanLocationContent";
            public const string EnterNavMeshLink = "InstructionDynamicContent/EnterNavMeshLink";
        }

        public static class NavigationUIText
        {
            public const string UpSlopeWarning = "Chú ý đường dốc lên phía trước";
            public const string DownSlopeWarning = "Chú ý đường dốc xuống phía trước";

            public const string UpStairWarning = "Chú ý bậc thang lên phía trước.\nNgưng dùng điện thoại";
            public const string DownStairWarning = "Chú ý bậc thang xuống phía trước.\nNgưng dùng điện thoại";
        }

        public static class UIText
        {
            public const string tryAgain = "Thử lại";
            public const string confirm = "Xác nhận";
            public const string continue1 = "Tiếp tục";
            public const string back = "Quay lại";
            public const string cancel = "Hủy bỏ";
            public const string yes = "Có";
            public const string no = "Không";
            public const string ignore = "Bỏ qua";
            public const string collect = "Thu thập";
            public const string distanceRemain = "Đang cách điểm đến";
            public const string Floor = "Tầng";
            public const string captureSave = "Ảnh đã được lưu vào thư viện";
            public const string photoAllow = "Cần cấp quyền lưu ảnh vào thư viện";
            public const string videoAllow = "Cần cấp quyền lưu video vào thư viện";
            public const string arNotSupport = "Không sử dụng được tính năng\ndo thiết bị không hỗ trợ AR";
            public const string connectionLost = "<line-height=150%>Mất kết nối mạng\r\n<size=14>Kiểm tra kết nối mạng và thử lại nhé!</size>";
            public const string webviewLoadFail = "<line-height=150%>Lỗi tải trang";
        }

        public static class PrefabResourceURL
        {
            public const string InstructionPrefab = "Instruction";
            public const string MinoPrefab = "Mino";
            public const string ImageAnchorPrefab = "ImageAnchor";
            public const string NoConectDialogPrefab = "NoConnectionPanel2";
            public const string LoadManager = "Prefabs/LoadManager";
            public const string Heart = "Prefabs/Heart";
            public const string GameInstruction = "Prefabs/GameInstruction";
            public const string ChallengeCompleted = "Prefabs/ChallengeCompleted";
            public const string Timer = "Prefabs/Timer";
            public const string LoadingPrefab = "loading7";
            public const string PopupDialog = "PopupDialog";
            public const string MapPointerPrefab = "MapPointer";
            public const string ARWarningPrefab = "ARWarning";
            public const string LessonItemPrefab = "LessonItem 1";
            public const string NotifyPrefab = "Notifier";
            public const string LoadingPlaceHolderPrefab = "LoadingPlaceHolder";
            public const string ImageContent = "ImageContent";
            public const string TextTemplate = "TextTemplate";

            public const string ScanGuide = "ScanGuide";
            //public const string Solar = "SolarSystem";

        }

        public class AnchoringTargetDownloadMessage
        {
            public List<AnchoringTarget> data;
        }

        public class BlockAnchoringResponse
        {
            public int status;
            public Anchoring data;
            public string message;
        }

        public class InferenceServerData
        {
            public int status;
            public string message;
            public string data;
        }
        public class LocationSettingsData
        {
            public int status;
            public string message;
            public LocationSettings data;
        }

        public static class MaterialResourceURL
        {
            public const string BannerMaterial = "Banner";
        }

        public static string hostDomain = "https://s3.educationxr.vn/";

        public static string androidPostfix = "_android";
        public static string iosPostfix = "_ios";
        public static string webglPostfix = "_webgl";
        public static string wsaPlayerPostfix = "_uwp";
        public static string standaloneWindows64Postfix = "_windows";
        public static string standaloneOSXPostfix = "_mac";

        public static int successCode = 200;
        public static int badRequestCode = 400;
        public static int notFound = 404;
        public static int milisecondCheckCancel = 100;
    }

    public class ColorModifiner
    {
        public float ColorMultiplier;
        public Color ColorOffset;

        public ColorModifiner(float multiplier, Color offset)
        {
            ColorMultiplier = multiplier;
            ColorOffset = offset;
        }
    }

    public class NavigatePathData
    {
        public List<NavigatePathSegment> segments = new List<NavigatePathSegment>();
    }

    public class NavigatePathSegment
    {
        public NavigatePathSegmentType type;
        public float distance;
        public bool isNavMeshLink;
        public Vector3 startPoint;
        public Vector3 endPoint;
        public GameObject startPointObject;
        public GameObject endPointObject;
    }

    public enum NavigatePathSegmentType
    {
        walk,
        escalatorUp,
        escalatorDown,
        elevatorUp,
        elevatorDown,
    }

    [Serializable]
    public class UserCollection
    {
        public string deviceID;
        public Vector3 position;
        public Vector3 Rotation;
    }

    [Serializable]
    public class AnalyticData
    {
        public string eventName;
        public Dictionary<string, object> data;
    }

    [Serializable]
    public class GiftData
    {
        public string ID;
        public string Title;
        public string Description;
        public string Code;
        public string Type;
        public string IconUrl;
        public string QRUrl;
    }
}
