using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public static class LanguageSetting
{
    // Start is called before the first frame update
    public static void SetLanguage(string language)
    {
        if (PlayerPrefs.HasKey("language"))
        {
            PlayerPrefs.SetString("language", language);
        }

        XenseARDictionary.Instance.ChangeLocalizationSelectedLanguage(language);
    }

    public static string GetLanguage()
    {
        return PlayerPrefs.GetString("language");
    }

    public static string InitLanguageSetting(string initUrl)
    {
        string language;
        
        if (!PlayerPrefs.HasKey("language"))
        {
            switch (Application.systemLanguage)
            {
                case SystemLanguage.English:
                    language = "en";
                    break;
                case SystemLanguage.Vietnamese:
                    language = "vi";
                    break;
                default:
                    language = "vi";
                    break;
            }
            PlayerPrefs.SetString("language", language);
        }
        else
        {
            language = PlayerPrefs.GetString("language");
        }

        if (initUrl.Contains("?")) return $"{initUrl}&lang={language}";
        else return $"{initUrl}?lang={language}";
    }
}
