using UnityEditor;
using UnityEngine;
using static UnityEngine.GridBrushBase;
namespace CBLP.MegaStudio
{
    [CustomEditor(typeof(SimplifiedDataManager))]
    public class SimplifiedDataManagerGUI : Editor
    {
        public override void OnInspectorGUI()
        {
            SimplifiedDataManager simplifiedDataManger = (SimplifiedDataManager)target;
            Title("Enter details");

            GUILayout.BeginHorizontal();
            GUILayout.Label("Block Id:");
            simplifiedDataManger.blockId = EditorGUILayout.TextField(simplifiedDataManger.blockId, GUILayout.MaxWidth(600));
            GUILayout.EndHorizontal();

            GUILayout.BeginHorizontal();
            GUILayout.Label("World Space Id:");
            simplifiedDataManger.worldSpaceId = GUILayout.TextField(simplifiedDataManger.worldSpaceId, GUILayout.MaxWidth(600));
            GUILayout.EndHorizontal();

            GUILayout.BeginHorizontal();
            GUILayout.Label("Group Id:");
            simplifiedDataManger.groupId = GUILayout.TextField(simplifiedDataManger.groupId, GUILayout.MaxWidth(600));
            GUILayout.EndHorizontal();

            GUILayout.Space(10);
            SeparateLine();

            GUILayout.BeginHorizontal();
            GUILayout.Label("Block Root: ");
            simplifiedDataManger.RootBlock = (XenseARBlockRoot)EditorGUILayout.ObjectField(simplifiedDataManger.RootBlock, typeof(XenseARBlockRoot), true);
            if (GUILayout.Button("Create Block Root", GUILayout.Width(150)))
            {
                simplifiedDataManger.CreateBlockRoot();
            }
            GUILayout.EndHorizontal();

            if (GUILayout.Button("Load Mesh"))
            {
                simplifiedDataManger.LoadBlockList();
            }

            if (simplifiedDataManger.importing)
            {
                if (GUILayout.Button("Cancel", GUILayout.MaxWidth(100)))
                {
                    Debug.Log("Cancel");
                    simplifiedDataManger.StopImportMesh();
                }
                GUILayout.EndHorizontal();
            }
            else if (simplifiedDataManger.hideChild)
            {
                HideChild(simplifiedDataManger.GetGameObject());
                simplifiedDataManger.hideChild = false;
            }

            SeparateLine();

            GUILayout.BeginHorizontal();
            GUILayout.FlexibleSpace();
            GUILayout.Label("-- Powered by Viettel --");
            GUILayout.FlexibleSpace();
            GUILayout.EndHorizontal();
        }

        private void HideChild(GameObject parent)
        {
            int childCount = parent.transform.childCount;
            for (int i = 0; i < childCount; i++)
            {
                SceneVisibilityManager.instance.DisablePicking(parent.transform.GetChild(i).gameObject, true);
                parent.transform.GetChild(i).gameObject.hideFlags = HideFlags.HideInHierarchy;
            }
        }

        //Title ========================================================================================
        private void Title(string title)
        {
            GUIStyle boldLabelStyle = new GUIStyle(GUI.skin.label);
            boldLabelStyle.fontStyle = FontStyle.Bold;
            GUILayout.Label(title, boldLabelStyle);
            GUILayout.Space(10);
        }

        private void SeparateLine()
        {
            HorizontalLine(new Color(0f, 0f, 0f, 0.5f), 2f);
        }

        //Draw Line================================================================================
        private readonly Color DEFAULT_COLOR = new Color(0f, 0f, 0f, 0.3f);
        private readonly Vector2 DEFAULT_LINE_MARGIN = new Vector2(2f, 2f);
        private const float DEFAULT_LINE_HEIGHT = 1f;

        private void HorizontalLine(Color color, float height, Vector2 margin)
        {
            GUILayout.Space(margin.x);
            EditorGUI.DrawRect(EditorGUILayout.GetControlRect(false, height), color);
            GUILayout.Space(margin.y);
        }

        private void HorizontalLine(Color color, float height) => HorizontalLine(color, height, DEFAULT_LINE_MARGIN);
        private void HorizontalLine(Color color, Vector2 margin) => HorizontalLine(color, DEFAULT_LINE_HEIGHT, margin);
        private void HorizontalLine(float height, Vector2 margin) => HorizontalLine(DEFAULT_COLOR, height, margin);
        private void HorizontalLine(Color color) => HorizontalLine(color, DEFAULT_LINE_HEIGHT, DEFAULT_LINE_MARGIN);
        private void HorizontalLine(float height) => HorizontalLine(DEFAULT_COLOR, height, DEFAULT_LINE_MARGIN);
        private void HorizontalLine(Vector2 margin) => HorizontalLine(DEFAULT_COLOR, DEFAULT_LINE_HEIGHT, margin);
        private void HorizontalLine() => HorizontalLine(DEFAULT_COLOR, DEFAULT_LINE_HEIGHT, DEFAULT_LINE_MARGIN);
        //End Draw Line============================================================================================
    }
}
