using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using TMPro;
using UnityEngine;
using UnityEngine.UI;
namespace XenseAR
{

    public class NavigationIconController : MonoBehaviour
    {
        [SerializeField] Image icon;
        [SerializeField] TextMeshProUGUI mainText;
        [SerializeField] TextMeshProUGUI subText;
        [SerializeField] GameObject status;
        public float pathLength = 0;
        public bool isVisible = false;

        public NavigatePathSegment NavigatePathSegmentData = new NavigatePathSegment();

        public void SetData(NavigatePathSegment data)
        {
            NavigatePathSegmentData = data;
            switch (data.type)
            {
                case NavigatePathSegmentType.walk:
                    mainText.text = data.distance.ToString("F0", CultureInfo.InvariantCulture) + "m";
                    pathLength = data.distance;
                    if (data.endPointObject != null)
                        subText.text = ConvertObjectName(data.endPointObject.name);
                    else if (data.startPointObject != null)
                        subText.text = ConvertObjectName(data.startPointObject.name);
                    else subText.gameObject.SetActive(false);
                    break;
                case NavigatePathSegmentType.escalatorUp:
                    pathLength = data.distance;
                    break;
                case NavigatePathSegmentType.escalatorDown:
                    pathLength = data.distance;
                    break;
                case NavigatePathSegmentType.elevatorUp:
                    break;
                case NavigatePathSegmentType.elevatorDown:
                    break;
            }
        }

        private string ConvertObjectName(string name)
        {
            string result = name;
            switch (name)
            {
                case "1F":
                    result = XenseARDictionary.Instance.GetLocalizationText(Defines.LocalizationKey.Floor) + " 1";
                    break;
                case "2F":
                    result = XenseARDictionary.Instance.GetLocalizationText(Defines.LocalizationKey.Floor) + " 2";
                    break;
                case "3F":
                    result = XenseARDictionary.Instance.GetLocalizationText(Defines.LocalizationKey.Floor) + " 3";
                    break;
                case "4F":
                    result = XenseARDictionary.Instance.GetLocalizationText(Defines.LocalizationKey.Floor) + " 4";
                    break;
                case "5F":
                    result = XenseARDictionary.Instance.GetLocalizationText(Defines.LocalizationKey.Floor) + " 5";
                    break;
                default:
                    break;
            }
            return result;
        }

        public void SetStatusIconVisibility(bool isVisible)
        {
            if (status != null)
            {
                status.SetActive(isVisible);
                this.isVisible = isVisible;
            }
        }
    }
}