using System;
using System.Collections.Generic;
using UnityEngine;
namespace XenseAR {

public class UIPanelsSliderController : MonoBehaviour
{
    public List<UIPanelSliderItem> sliderItems = new List<UIPanelSliderItem>();

    public Action onSliderDestroy;

    private void Start()
    {
        for (int i = transform.childCount - 1; i >= 0; i--)
        {
            UIPanelSliderItem item = transform.GetChild(i).GetComponent<UIPanelSliderItem>();
            if (item != null)
                sliderItems.Add(item);
        }

        string check = PlayerPrefs.GetString(Defines.PlayerPrefsKey.Skip + gameObject.name);

        if (string.IsNullOrEmpty(check)) check = "false";

        if (bool.Parse(check))
        {
            sliderItems[0].MoveToLastPanel(true);
        }
    }

    public void Skip()
    {
        PlayerPrefs.SetString(Defines.PlayerPrefsKey.Skip + gameObject.name, true.ToString());
    }

    private void OnDestroy()
    {
        onSliderDestroy?.Invoke();
    }
}
}
