using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
namespace XenseAR {

public class EndNavigationButtonController : MonoBehaviour
{
    [SerializeField] Button endNavigationButton;
    [SerializeField] NavigationSystemManager navigationSystemManager;

    private void Start()
    {
        endNavigationButton.onClick.AddListener(EndNavigation);
    }

    private void OnDestroy()
    {
        endNavigationButton.onClick.RemoveAllListeners();
    }

    public void EndNavigation()
    {
        PopupDialog.instance.showButtonsDialog(PopupDialog.DialogTemplate.Question, XenseARDictionary.Instance.GetLocalizationText(Defines.LocalizationKey.stopNavigationConfirmation),
            new List<string>() { XenseARDictionary.Instance.GetLocalizationText(Defines.LocalizationKey.cancel), "OK"},
            new List<Action>()
            {
                null,
                () => {
                    navigationSystemManager.EndNavigation();
                    AnalyticsSender.Instance.SendEvent("userStopNavigation", "navigation");
                }
            },
            new List<Color?> { Color.white, Defines.Theme.ThemeColor },
            new List<Color?> { Defines.Theme.ThemeNormalTextColor, Defines.Theme.ThemeBoldTextColor },
            new List<Color?> { Defines.Theme.ThemeNormalTextColor });
    }
}
}
