using System.Collections.Generic;
using System.Linq;

using UnityEngine;
using UnityEngine.VFX;

public static class ReApplyShaders
{
   public static void Start(GameObject go)
    {
#if !UNITY_WEBGL || UNITY_EDITOR
        List<Renderer> renderers = go.GetComponentsInChildren<Renderer>(true).ToList();
        List<Material> materials = new List<Material>();

        foreach (var rend in renderers)
        {
            if (rend.GetComponent<VisualEffect>()) continue;

            foreach (var material in rend.sharedMaterials)
            {
                if (!materials.Contains(material))
                    materials.Add(material);
            }
        }

        foreach (var material in materials)
        {
            if (material != null && material.shader != null && !string.IsNullOrEmpty(material.shader.name) && Shader.Find(material.shader.name) != null)
                material.shader = Shader.Find(material.shader.name);
        }

        renderers = null;
        materials = null;
#endif
    }
}