using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Splines;
public class SplineController : MonoBehaviour
{

    [SerializeField] SplineAnimate splineanim;
    [SerializeField] Animator DragonAnimator;
    [SerializeField] ParticleSystem fireBreathParticle;
    private void Awake()
    {

    }

    // Start is called before the first frame update
    void Start()
    {
        Invoke("StartOffset", 1);
    }

    void StartOffset()
    {
        Invoke("Onfinish", splineanim.Duration + 7f + 7f + 4f);
        Invoke("FlyToIdle", 0);
        Invoke("IdleToFly", 3);
        Invoke("FlyToRoar", 10);
        Invoke("Fire", 14f);
        Invoke("RoarToFly", 17f);
        Invoke("FlyToRoar", 28f);
        Invoke("Fire", 32.4f);
        Invoke("RoarToFly", 35f);
    }
    void Onfinish()
    {
        DragonAnimator.SetBool("IsFlying", true);
        DragonAnimator.SetBool("IsIdle", false);
        DragonAnimator.SetBool("IsRoaring", false);
        DragonAnimator.SetFloat("Speed", 0);
        Invoke("StartOffset", 1f);
        splineanim.Restart(false);
        Debug.Log("Finish!");
    }

    private void SplinePause()
    {
        splineanim.Pause();
    }

    private void SplinePlay()
    {
        splineanim.Play();
    }

    private void IdleToFly()
    {
        DragonAnimator.SetBool("IsIdle", true);
        DragonAnimator.SetBool("IsFlying", false);
        DragonAnimator.SetBool("IsRoaring", false);
        DragonAnimator.SetFloat("Speed", 1);
        SplinePlay();
    }

    private void FlyToIdle()
    {
        DragonAnimator.SetBool("IsFlying", true);
        DragonAnimator.SetBool("IsIdle", false);
        DragonAnimator.SetBool("IsRoaring", false);
        DragonAnimator.SetFloat("Speed", 0);
        SplinePause();
    }

    private void FlyToRoar()
    {
        DragonAnimator.SetBool("IsFlying", true);
        DragonAnimator.SetBool("IsIdle", false);
        DragonAnimator.SetBool("IsRoaring", false);
        DragonAnimator.SetFloat("Emotion", 1);
        SplinePause();
    }

    private void RoarToFly()
    {
        DragonAnimator.SetBool("IsRoaring", true);
        DragonAnimator.SetBool("IsIdle", false);
        DragonAnimator.SetBool("IsFlying", false);
        DragonAnimator.SetFloat("Emotion", 0);
        SplinePlay();
    }

    private void Fire()
    {
        fireBreathParticle.Play();
    }

    private void IdleToRoar()
    {

    }

    private void RoarToIdle()
    {

    }

}
