using System;
using System.Collections.Generic;
using UnityEngine;

namespace XenseAR
{
    [Serializable]
    public class AnimationCommandInfo
    {
        public string id;// anchoring id
        public string name; // animation name
    }


    [Serializable]
    public class BlockNavigationTargetsResponse
    {
        public int status;
        public Navigation data;
        public string message;
    }

    [Serializable]
    public class BlockNavigationTargetResponse
    {
        public int status;
        public NavigationTarget data;
        public string message;
    }

    [Serializable]
    public class BlockNavigationMeshResponse
    {
        public int status;
        public List<NavigationMesh> data;
        public string message;
    }

    [Serializable]
    public class LocationInfosResponseData
    {
        public int status;
        public List<LocationInfo> data;
        public string message;
    }

    [Serializable]
    public class WorldData
    {
        public string worldId;
        public string title;
        public List<string> listActivity = new List<string>();
    }

    public class BlockWorldsData
    {
        public int status;
        public string message;
        public List<WorldData> data;
    }

    public class BlockWorldData
    {
        public int status;
        public string message;
        public WorldData data;
    }

    [Serializable]
    public class GiftResponseCount
    {
        public int status;
        public int data;
        public string message;
    }

    [Serializable]
    public class GiftResponseData
    {
        public int status;
        public GiftData data;
        public string message;
    }

    [Serializable]
    public class GameSessionInfoData
    {
        // public string condition;
        // public string config;
        // public string hash;
        public GameSessionInfo info;
        // public string session_count;
        // public string remain_count;
        // public string timeout;
        // public string url;
    }

    [Serializable]
    public class ObjectTrackingResponse
    {
        public int status;
        public string message;
        public List<ObjectTrackingData> data;
    }

    [Serializable]
    public class GameSessionInfo
    {
        public int timestamp;
        public int expire_time;
    }

    [Serializable]
    public class Get2dInteraction
    {
        public string status;
        public string message;
        public Get2dInteractionInfo data;
    }
    [Serializable]
    public class Get2dInteractionInfo
    {
        public string type;
        public string data;
    }

    [Serializable]
    public class EventData
    {
        public int status;
        public EventDataJson data;
        public string message;
    }

    [Serializable]
    public class EventDataJson
    {
        public string m_EventID;
        public string m_EventTitle;
        public string m_EventDes;
        public string m_EventIcon;
        public string blockID;
    }
    [Serializable]
    public class requireAnchorGroupsResponse
    {
        public List<anchorGroupName> anchoringGroups;
    }
    [Serializable]
    public class anchorGroupName
    {
        public string name;
    }

    [Serializable]
    public class requireLocationGroupsResponse
    {
        public List<locationGroupName> locationInfoGroups;
    }
    [Serializable]
    public class locationGroupName
    {
        public string name;
    }

    [Serializable]
    public class GamePrefabManagerInfo
    {
        public string url;
        public string path;
    }

    [Serializable]
    public class GameBulletInfo
    {
        public string bullet;
        public float speed;
        public string vfx;
    }

    [Serializable]
    public class GameVFXInfo
    {
        public string type;
        public string vfx;
        public Vector3 pos;
    }

    [Serializable]
    public class SplineInfo
    {
        public string id;
        public string name;
    }
}
