using UnityEditor;
using UnityEngine;
namespace CBLP.MegaStudio
{

[CustomEditor(typeof(XenseARBlockTool))]
public class XenseARBlockToolGUI : Editor
{
    public override void OnInspectorGUI()
    {
        //DrawDefaultInspector();
        XenseARBlockTool xenseARBlockTool = (XenseARBlockTool)target;

        GUIStyle yellowStyle = new GUIStyle(GUI.skin.label);
        yellowStyle.normal.textColor = Color.yellow;
        yellowStyle.fontStyle = FontStyle.Bold;
        yellowStyle.alignment = TextAnchor.MiddleLeft;
        yellowStyle.fontSize = 20;
        GUILayout.Label("Xense AR", yellowStyle, GUILayout.MaxWidth(300));
        SeparateLine();

        GUILayout.Space(20);

        if (!xenseARBlockTool.loggedIn)
        {
            Title("Sign In");

            GUILayout.BeginHorizontal();
            GUILayout.Label("Account:   ");
            xenseARBlockTool.account = EditorGUILayout.TextField(xenseARBlockTool.account, GUILayout.MaxWidth(600));
            GUILayout.EndHorizontal();

            GUILayout.BeginHorizontal();
            GUILayout.Label("Password:");
            xenseARBlockTool.password = GUILayout.PasswordField(xenseARBlockTool.password, '*', GUILayout.MaxWidth(600));
            GUILayout.EndHorizontal();
            if (GUILayout.Button("Log In"))
            {
                XenseStudioSetting.getStudioConfig();
                xenseARBlockTool.StudioConfig = XenseStudioSetting.StudioSetting;
                xenseARBlockTool.Login();
            }
        }

        if (xenseARBlockTool.loggedIn)
        {
            GUILayout.BeginHorizontal();
            GUIStyle blueStyle = new GUIStyle(GUI.skin.label);
            blueStyle.normal.textColor = Color.blue;
            blueStyle.fontStyle = FontStyle.Bold;
            blueStyle.alignment = TextAnchor.MiddleLeft;
            blueStyle.fontSize = 14;
            GUILayout.Label("User: ", GUILayout.MaxWidth(60));
            GUILayout.Label(xenseARBlockTool.account, blueStyle);
            if (GUILayout.Button("Log Out"))
            {
                xenseARBlockTool.LogOut();
            }
            GUILayout.EndHorizontal();
        }

        GUILayout.Space(10);
        SeparateLine();

        if (xenseARBlockTool.loggedIn)
        {
            GUILayout.Space(30);
            GUILayout.BeginHorizontal();
            GUILayout.Label("Block Root: ");
            xenseARBlockTool.RootBlock = (XenseARBlockRoot) EditorGUILayout.ObjectField(xenseARBlockTool.RootBlock, typeof(XenseARBlockRoot), true);
            if (GUILayout.Button("Create Block Root", GUILayout.Width(150)))
            {
                xenseARBlockTool.CreateBlockRoot();
            }
            GUILayout.EndHorizontal();
            SeparateLine();
            GUILayout.Space(10);
            if(xenseARBlockTool.RootBlock != null)
            {
                if (GUILayout.Button("Load Block List", GUILayout.Width(100)))
                {
                    xenseARBlockTool.LoadBlockList();
                }
                GUILayout.Space(10);
                Title("Block List");

                GUILayout.BeginHorizontal();
                GUILayout.Label("List count: ");
                GUILayout.Label(xenseARBlockTool.Blocks.Count + "");
                if (GUILayout.Button("Clear Meshes", GUILayout.Width(100)))
                {
                    xenseARBlockTool.ClearChild(xenseARBlockTool.GetGameObject());
                }
                GUILayout.EndHorizontal();

                GUILayout.Space(10);
                GUILayout.BeginHorizontal();
                GUILayout.Label("Search by Name: ");
                xenseARBlockTool.searchKey = EditorGUILayout.TextField(xenseARBlockTool.searchKey, GUILayout.MaxWidth(300));
                if (GUILayout.Button("Search", GUILayout.Width(100)))
                {
                    xenseARBlockTool.Search();
                }
                GUILayout.EndHorizontal();

                xenseARBlockTool.scrollPosition = GUILayout.BeginScrollView(xenseARBlockTool.scrollPosition, GUILayout.Height(200));
                foreach (var block in xenseARBlockTool.Blocks)
                {
                    ListItem(xenseARBlockTool, block.blockId, block.title, block.url, xenseARBlockTool.Blocks.IndexOf(block));
                }
                GUILayout.EndScrollView();
            }

            SeparateLine();

            GUILayout.BeginHorizontal();
            GUILayout.FlexibleSpace();
            GUILayout.Label("-- Powered by Viettel --");
            GUILayout.FlexibleSpace();
            GUILayout.EndHorizontal();
        }

    }

    private void SeparateLine()
    {
        HorizontalLine(new Color(0f, 0f, 0f, 0.5f), 2f);
    }

    [MenuItem("ARWorld/Settings/Studio Setting", false, 40)]
    static void Init()
    {
        XenseStudioSetting window = EditorWindow.GetWindow(typeof(XenseStudioSetting)) as XenseStudioSetting;
        window.position = new Rect(Screen.width / 2, Screen.height / 2, 800, 150);
    }

    //List Item==============================================================================================
    private void ListItem(XenseARBlockTool tool, string id, string title, string url, int index)
    {
        GUILayout.Space(5);
        GUIStyle myStyle = new GUIStyle();
        myStyle.normal.background = Texture2D.grayTexture;
        myStyle.normal.textColor = Color.white;
        myStyle.padding = new RectOffset(10, 10, 10, 10);

        GUILayout.BeginHorizontal(myStyle);
        GUILayout.Label("Block: " + index);

        GUILayout.Label(title);

        if (GUILayout.Button("Import Mesh", GUILayout.MaxWidth(100)))
        {
            tool.ImportMesh(id, url);
        }
        
        if (GUILayout.Button("Export Model", GUILayout.MaxWidth(100)))
        {
            string saveFolderPath = EditorUtility.OpenFolderPanel("Save Model", "", "");
            tool.ExportModel(id, url, saveFolderPath);
            if (!string.IsNullOrEmpty(saveFolderPath)) {
                GUILayout.BeginHorizontal();
                GUILayout.BeginScrollView(Vector2.zero, GUILayout.Height(0));
            }
            else
            {
                GUILayout.BeginScrollView(Vector2.zero, GUILayout.Height(0));
            }
        }

        GUILayout.EndHorizontal();

        if (tool.importing && !string.IsNullOrEmpty(tool.importUrl) && url.Equals(tool.importUrl))
        {
            GUILayout.BeginHorizontal(myStyle);
            GUILayout.FlexibleSpace();
            GUILayout.Label(tool.message);
            GUILayout.FlexibleSpace();
            if (GUILayout.Button("Cancel", GUILayout.MaxWidth(100)))
            {
                Debug.Log("Cancel");
                tool.StopImportMesh();
            }
            GUILayout.EndHorizontal();
        } 
        else if(tool.hideChild)
        {
            HideChild(tool.GetGameObject());
            tool.hideChild = false;
        }
    }
    //End List Item==============================================================================================

    private void HideChild(GameObject parent)
    {
        int childCount = parent.transform.childCount;
        for (int i = 0; i < childCount; i++)
        {
            SceneVisibilityManager.instance.DisablePicking(parent.transform.GetChild(i).gameObject, true);
            parent.transform.GetChild(i).gameObject.hideFlags = HideFlags.HideInHierarchy;
        }
    }

    //Title ========================================================================================
    private void Title(string title)
    {
        GUIStyle boldLabelStyle = new GUIStyle(GUI.skin.label);
        boldLabelStyle.fontStyle = FontStyle.Bold;
        GUILayout.Label(title, boldLabelStyle);
        HorizontalLine(new Color(1f, 1f, 1f, 0.5f), 2f);
        GUILayout.Space(10);
    }

    //End Tile========================================================================================


    //Draw Line================================================================================
    private readonly Color DEFAULT_COLOR = new Color(0f, 0f, 0f, 0.3f);
    private readonly Vector2 DEFAULT_LINE_MARGIN = new Vector2(2f, 2f);
    private const float DEFAULT_LINE_HEIGHT = 1f;

    private void HorizontalLine(Color color, float height, Vector2 margin)
    {
        GUILayout.Space(margin.x);
        EditorGUI.DrawRect(EditorGUILayout.GetControlRect(false, height), color);
        GUILayout.Space(margin.y);
    }

    private void HorizontalLine(Color color, float height) => HorizontalLine(color, height, DEFAULT_LINE_MARGIN);
    private void HorizontalLine(Color color, Vector2 margin) => HorizontalLine(color, DEFAULT_LINE_HEIGHT, margin);
    private void HorizontalLine(float height, Vector2 margin) => HorizontalLine(DEFAULT_COLOR, height, margin);
    private void HorizontalLine(Color color) => HorizontalLine(color, DEFAULT_LINE_HEIGHT, DEFAULT_LINE_MARGIN);
    private void HorizontalLine(float height) => HorizontalLine(DEFAULT_COLOR, height, DEFAULT_LINE_MARGIN);
    private void HorizontalLine(Vector2 margin) => HorizontalLine(DEFAULT_COLOR, DEFAULT_LINE_HEIGHT, margin);
    private void HorizontalLine() => HorizontalLine(DEFAULT_COLOR, DEFAULT_LINE_HEIGHT, DEFAULT_LINE_MARGIN);
    //End Draw Line============================================================================================
}
}
