using UnityEditor;
using UnityEngine;

public class XenseStudioSetting : EditorWindow
{
    public static XenseStudioConfigScriptableObjectScript StudioSetting;
    private static string hostUrl = "";
    private static string authenRoute = "";
    private static bool overrideAuthenRoute = false;
    private string message = "";

    private void OnEnable()
    {
        string guid = EditorPrefs.GetString("XenseStudio_Setting_GUID", "");
        if (!string.IsNullOrEmpty(guid))
        {
            string path = AssetDatabase.GUIDToAssetPath(guid);
            StudioSetting = AssetDatabase.LoadAssetAtPath<XenseStudioConfigScriptableObjectScript>(path);
            hostUrl = StudioSetting.hostUrl;
            authenRoute = StudioSetting.authenRoute;
            overrideAuthenRoute = StudioSetting.overrideAuthenRoute;
        }
    }

    public static void getStudioConfig()
    {
        string guid = EditorPrefs.GetString("XenseStudio_Setting_GUID", "");
        if (!string.IsNullOrEmpty(guid))
        {
            string path = AssetDatabase.GUIDToAssetPath(guid);
            StudioSetting = AssetDatabase.LoadAssetAtPath<XenseStudioConfigScriptableObjectScript>(path);
            hostUrl = StudioSetting.hostUrl;
            authenRoute = StudioSetting.authenRoute;
            overrideAuthenRoute = StudioSetting.overrideAuthenRoute;
        }
    }

    void OnGUI()
    {
        Title("Settings");

        GUILayout.BeginHorizontal();
        GUIStyle redLabel = new GUIStyle(GUI.skin.label);
        redLabel.richText = true;
        GUILayout.Label($"<color=red>{message}</color>", redLabel);
        GUILayout.EndHorizontal();

        EditorGUI.BeginChangeCheck();
        GUILayout.BeginHorizontal();
        GUILayout.Label("Setting Object:");
        StudioSetting = (XenseStudioConfigScriptableObjectScript)EditorGUILayout.ObjectField(StudioSetting, typeof(XenseStudioConfigScriptableObjectScript), true);
        GUILayout.EndHorizontal();
        if (EditorGUI.EndChangeCheck())
        {
            if(StudioSetting != null)
            {
                message = "";
                hostUrl = StudioSetting.hostUrl;
                authenRoute = StudioSetting.authenRoute;
                overrideAuthenRoute = StudioSetting.overrideAuthenRoute;
                EditorPrefs.SetString("XenseStudio_Setting_GUID", AssetDatabase.AssetPathToGUID(AssetDatabase.GetAssetPath(StudioSetting)));
                EditorUtility.SetDirty(StudioSetting);
            } else
            {
                hostUrl = "";
                authenRoute = "";
                overrideAuthenRoute = false;
            }
        }

        EditorGUI.BeginChangeCheck();

        GUILayout.BeginHorizontal();
        GUILayout.Label("Host Url:");
        hostUrl = EditorGUILayout.TextField(hostUrl, GUILayout.MaxWidth(600));
        GUILayout.EndHorizontal();

        GUILayout.BeginHorizontal();
        GUILayout.Label("Auth Route:");
        authenRoute = EditorGUILayout.TextField(authenRoute, GUILayout.MaxWidth(600));
        GUILayout.EndHorizontal();

        GUILayout.BeginHorizontal();
        GUILayout.Label("Override Auth Route:");
        overrideAuthenRoute = EditorGUILayout.Toggle("", overrideAuthenRoute);
        GUILayout.EndHorizontal();

        if (EditorGUI.EndChangeCheck())
        {
            if (StudioSetting == null) message = "Please select Setting Object first!";
            else
            {
                message = "";
                StudioSetting.hostUrl = hostUrl;
                StudioSetting.authenRoute = authenRoute;
                StudioSetting.overrideAuthenRoute = overrideAuthenRoute;
                EditorUtility.SetDirty(StudioSetting);
            }
        }
    }

    //Title ========================================================================================
    private void Title(string title)
    {
        GUIStyle boldLabelStyle = new GUIStyle(GUI.skin.label);
        boldLabelStyle.fontStyle = FontStyle.Bold;
        GUILayout.Label(title, boldLabelStyle);
        HorizontalLine(new Color(1f, 1f, 1f, 0.5f), 2f);
        GUILayout.Space(10);
    }

    //End Tile========================================================================================

    //Draw Line================================================================================
    private readonly Color DEFAULT_COLOR = new Color(0f, 0f, 0f, 0.3f);
    private readonly Vector2 DEFAULT_LINE_MARGIN = new Vector2(2f, 2f);
    private const float DEFAULT_LINE_HEIGHT = 1f;

    private void HorizontalLine(Color color, float height, Vector2 margin)
    {
        GUILayout.Space(margin.x);
        EditorGUI.DrawRect(EditorGUILayout.GetControlRect(false, height), color);
        GUILayout.Space(margin.y);
    }

    private void HorizontalLine(Color color, float height) => HorizontalLine(color, height, DEFAULT_LINE_MARGIN);
    private void HorizontalLine(Color color, Vector2 margin) => HorizontalLine(color, DEFAULT_LINE_HEIGHT, margin);
    private void HorizontalLine(float height, Vector2 margin) => HorizontalLine(DEFAULT_COLOR, height, margin);
    private void HorizontalLine(Color color) => HorizontalLine(color, DEFAULT_LINE_HEIGHT, DEFAULT_LINE_MARGIN);
    private void HorizontalLine(float height) => HorizontalLine(DEFAULT_COLOR, height, DEFAULT_LINE_MARGIN);
    private void HorizontalLine(Vector2 margin) => HorizontalLine(DEFAULT_COLOR, DEFAULT_LINE_HEIGHT, margin);
    private void HorizontalLine() => HorizontalLine(DEFAULT_COLOR, DEFAULT_LINE_HEIGHT, DEFAULT_LINE_MARGIN);
    //End Draw Line============================================================================================
}
