using System.IO;
using System.Threading.Tasks;
using UFD;
using Unity.SharpZipLib.Utils;
using UnityEngine;

public class ZipDownloader
{
    string cachePath = Application.persistentDataPath;
    public void test()
    {
        DownloadAndUnzip("https://s3.educationxr.vn/ar-world/ObjectTrackingData/Meta_Quest_Pro.zip", null);
    }
    public async Task<string> DownloadAndUnzip(string url, string password)
    {

        UnityFileDownloader ufd = new UnityFileDownloader(new string[] {
            url,
        });
        ufd.DownloadPath = cachePath;
        ufd.ContinueAfterFailure = true;
        string archivePath = Path.Combine(ufd.DownloadPath, Path.GetFileName(url));
        if (File.Exists(archivePath))
        {
        }
        else
        {
            await ufd.Download();

        }
        string tempExtractPath = Path.Combine(ufd.DownloadPath, Path.GetFileNameWithoutExtension(url));
        ZipUtility.UncompressFromZip(archivePath, password, tempExtractPath);
        return tempExtractPath;
    }
}
