using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
public class ProgressBar : MonoBehaviour
{
    [SerializeField] Slider Bar;
    [SerializeField] Text Name;
    [SerializeField] Text Percentage;
    // Start is called before the first frame update

    private Animator animator;
    void Start()
    {
        Bar.interactable = false;
    }

    // Update is called once per frame
    void Update()
    {
        Percentage.text = (int)(Bar.value * 100) + "%";
    }

    public void UpdatePercentage(float value)
    {
        //hot fix for wrong flickering percentage
        if (value >= Bar.value)
            Bar.value = value;
    }

    public void DestroyLoadBar()
    {
        animator = gameObject.GetComponent<Animator>();
        if (animator != null)
        {
            animator.SetBool("Fadeout", true);
            StartCoroutine(DestroyAfterAnimation());
        }
    }

    private IEnumerator DestroyAfterAnimation()
    {
        // Wait until the "Fadeout" animation is finished
        yield return new WaitForSeconds(animator.GetCurrentAnimatorStateInfo(0).length);

        // Destroy the GameObject after the animation is complete
        Destroy(gameObject);
    }

    public void UpdateName(string name)
    {
        Name.text = name;
    }

    public void UpdatePercentageText(string value)
    {
        Percentage.text = value;
    }
}
