
using System.Collections.Generic;
using System.IO;
using UnityEngine;
using XenseAR.Localization;

public class XenseARDictionary : MonoBehaviour
{
    public DictionaryOverviewObject dictionaryOverviewData;
    private static XenseARDictionary m_Instance = null;
    static bool shuttingDown = false;

    // Declare a delegate type for events
    public delegate void OnUpdateTextEvent();
    List<OnUpdateTextEvent> listeners = new List<OnUpdateTextEvent>();


    public static class Keys
    {
        public const string hello = "hello";
        public const string hello2 = "hello2";
        public const string hello3 = "hello3";
    }

    public void RegisterToUpdateText(OnUpdateTextEvent onUpdateTextEvent)
    {
        listeners.Add(onUpdateTextEvent);
    }

    public void UnRegisterToUpdateText(OnUpdateTextEvent onUpdateTextEvent)
    {
        listeners.Remove(onUpdateTextEvent);
    }

    public void PerformUpdateText()
    {
        foreach (var listener in listeners)
        {
            listener();
        }
    }

    public string GetLocalizationText(string key)
    {
        string result = key;
        if (dictionaryOverviewData.dictionaryOverview.currentLanguageText.ContainsKey(key))
        {
            dictionaryOverviewData.dictionaryOverview.currentLanguageText.TryGetValue(key, out result);
        } else if (dictionaryOverviewData.dictionaryOverview.fallbackText.ContainsKey(key))
        {
            dictionaryOverviewData.dictionaryOverview.fallbackText.TryGetValue(key, out result);
        }
        return result;
    }

    public void ChangeLocalizationSelectedLanguage(string languageKey)
    {
        dictionaryOverviewData.dictionaryOverview.selectedLaguage = languageKey;
        PopulateDictionary();
        PerformUpdateText();
    }

    private void PopulateDictionary()
    {
        string dictionaryDirectory = Path.Combine(Application.persistentDataPath, "Dictionary");
        foreach (XenseARLanguage item in dictionaryOverviewData.dictionaryOverview.languages)
        {
            if (dictionaryOverviewData.dictionaryOverview.selectedLaguage.Equals(item.key))
            {
                //read data from file
                // load to dictionary
                string fileData = FileUtility.ReadFileData(dictionaryDirectory, item.dictionaryPath);
                LocalizationDataList datas = JsonUtility.FromJson<LocalizationDataList>(fileData);
                dictionaryOverviewData.dictionaryOverview.currentLanguageText.Clear();
                foreach (LocalizationData data in datas.data)
                {
                    dictionaryOverviewData.dictionaryOverview.currentLanguageText.Add(data.key, data.text);
                }
                break;
            }
        }
    }

    public static XenseARDictionary Instance
    {
        get
        {
            if (m_Instance == null && !shuttingDown && Application.isPlaying)
            {
                m_Instance = FindObjectOfType(typeof(XenseARDictionary)) as XenseARDictionary;

                if (m_Instance == null)
                {
                    Debug.Log("No instance of " + typeof(XenseARDictionary).ToString() + ", a temporary one is created.");

                    m_Instance = new GameObject(typeof(XenseARDictionary).ToString(), typeof(XenseARDictionary)).GetComponent<XenseARDictionary>();
                }
            }
            return m_Instance;

        }
    }

    protected virtual void Awake()
    {
        DontDestroyOnLoad(this);
        m_Instance = this as XenseARDictionary;
        if (m_Instance == null)
            m_Instance = this as XenseARDictionary;
        else if (m_Instance != this)
        {
            Debug.LogError("Another instance of " + GetType() + " is already exist! Destroying self...");
            DestroyImmediate(gameObject);
            return;
        }
    }

    protected virtual void OnDestroy()
    {
        if (this == m_Instance)
            m_Instance = null;
    }

    private void OnApplicationQuit()
    {
        m_Instance = null;
        //  shuttingDown = true;
    }

}
