using System;
using System.Collections.Generic;
using UnityEngine;

namespace XenseAR.Localization
{
    [CreateAssetMenu(fileName = "DictionaryOverviewObject", menuName = "ScriptableObjects/DictionaryOverviewObject", order = 1)]
    public class DictionaryOverviewObject : ScriptableObject
    {
        public DictionaryOverview dictionaryOverview = new DictionaryOverview();
    }

    [Serializable]
    public class DictionaryOverview
    {
        public string version;
        public List<XenseARLanguage> languages = new List<XenseARLanguage>();
        public string selectedLaguage;
        public Dictionary<string, string> fallbackText = new Dictionary<string, string>();
        public Dictionary<string, string> currentLanguageText = new Dictionary<string, string>();
    }

    [Serializable]
    public class XenseARLanguage
    {
        public string key;
        public string name;
        public string dictionaryPath;
    }

    [Serializable]

    public class LocalizationData
    {
        public string key;
        public string text;
    }

    [Serializable]
    public class  LocalizationDataList
    {
        public List<LocalizationData> data = new List<LocalizationData>();
    }
}


