using UnityEngine;
using UnityEngine.UI;

public class LocalizationTextApplier : MonoBehaviour
{
    [SerializeField] public string localizationKey;
    // Start is called before the first frame update
    void Start()
    {
        XenseARDictionary.Instance.RegisterToUpdateText(UpdateLocalizationText);
    }

    private void OnEnable()
    {
        UpdateLocalizationText();
    }

    private void OnDestroy()
    {
        XenseARDictionary.Instance.UnRegisterToUpdateText(UpdateLocalizationText);
    }

    private void UpdateLocalizationText()
    {
        if(gameObject.GetComponent<TMPro.TMP_Text>() != null)
        {
            gameObject.GetComponent<TMPro.TMP_Text>().SetText(XenseARDictionary.Instance.GetLocalizationText(localizationKey));
        }
        else if (gameObject.GetComponent<Text>() != null)
        {
            gameObject.GetComponent<Text>().text = (XenseARDictionary.Instance.GetLocalizationText(localizationKey));
        }
    }
}
