/*
 * Copyright 2017 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#import <ARKit/ARKit.h>
#import <Metal/Metal.h>
#import <MetalKit/MetalKit.h>
#import <QuartzCore/QuartzCore.h>
#import <UIKit/UIKit.h>
#import <WebKit/WebKit.h>
NS_ASSUME_NONNULL_BEGIN
@interface ViewControllerSDK:NSObject  <WKUIDelegate,
                                              WKNavigationDelegate,
                                              UITextFieldDelegate,
                                              ARSessionDelegate,
                                              ARSessionObserver,
                                              WKScriptMessageHandler> {
    
 
    
    MTKView *mtkView;
    WKWebView *wkWebView;


    UITextField *urlTextField;
    bool urlTextFieldActive;
    UIButton *backButton;
    UIButton *refreshButton;

    bool initialPageLoadedWhenTrackingBegins;

    UIDeviceOrientation deviceOrientation;
    UIInterfaceOrientation interfaceOrientation;
    bool updateWindowSize;

    float near;
    float far;

    bool showingCameraFeed;
    bool iPhoneXDevice;
    UIColor *wkWebViewOriginalBackgroundColor;

    NSMutableDictionary *jsAnchorIdsToObjCAnchorIds;
    NSMutableDictionary *objCAnchorIdsToJSAnchorIds;
    NSMutableDictionary *anchors;

    // These flags control the synchronization between the natively
    // rendered camera frame and the 3D scene rendered in the JS side.
    bool drawNextCameraFrame;
    bool sendARData;

    CFTimeInterval timeOfLastDrawnCameraFrame;
}
@property (nonatomic, strong) WKWebView *wkWebView; 
@property (nonatomic, strong) UIView *view;
@property (nonatomic, assign) CVPixelBufferRef lastCapturedFrame;
@property (nonatomic, strong) NSTimer *timer;
@property (nonatomic, strong) CIContext *ciContext;
@property (nonatomic, assign) CGSize targetSize;

- (void)loadURL:(NSString *)urlString;
// ✅ Explicitly expose to Swift
- (instancetype)initWithView:(UIView *)view webView:(WKWebView *)webView NS_DESIGNATED_INITIALIZER NS_SWIFT_NAME(init(view:webView:));


@end
NS_ASSUME_NONNULL_END
