//
//  UnityFramework
//
//  Created by VHT on 05/04/2024.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

__attribute__ ((visibility("default")))
@interface XenseARUnityInterface : NSObject{}

typedef void (*ErrorCb)(const void* someInstance, const char* errorMsg);
typedef void (*SuccessCb)(const void* obj,const char* successMsg);
typedef void (*GetCameraFrameImageSuccessCb)(const void* obj, const void* pngImageData, int dataSize);
typedef void (*GetDeformableDataSuccessCb)(const void* someInstance, const void* bytes, int dataSize);

// call these any time after UnityFrameworkLoad
+ (void) SendCommandStringInterface:(NSString*)type value:(NSString*)value successCallback:(SuccessCb)success errorCallback:(ErrorCb)error objectPointer:(const void*)ptr;

@end

NS_ASSUME_NONNULL_END
